/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.FeatureFlags;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.admin.indices.refresh.RefreshStats;
import io.skylite.core.action.admin.indices.stats.CommonStats;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.cache.query.QueryCacheStats;
import io.skylite.core.index.engine.CommitStats;
import io.skylite.core.index.engine.SegmentsStats;
import io.skylite.core.index.fielddata.FieldDataStats;
import io.skylite.core.index.flush.FlushStats;
import io.skylite.core.index.get.GetStats;
import io.skylite.core.index.merge.MergeStats;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.index.store.StoreStats;
import io.skylite.core.index.warmer.WarmerStats;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.search.stats.SearchStats;
import io.skylite.core.search.suggest.completion.CompletionStats;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestShardsAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestShardsAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/shards"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/shards/{index}")));
    }

    @Override
    public String getName() {
        return "cat_shards_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/shards\n");
        sb.append("/_cat/shards/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        final String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestShardsAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        clusterStateRequest.clear().nodes(true).routingTable(true).indices(indices);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) {
                IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
                indicesStatsRequest.all();
                indicesStatsRequest.indices(indices);
                client.admin().indices().stats(indicesStatsRequest, (ActionListener)new RestResponseListener<IndicesStatsResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(IndicesStatsResponse indicesStatsResponse) throws Exception {
                        return RestTable.buildResponse(RestShardsAction.this.buildTable(request, clusterStateResponse, indicesStatsResponse), this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders().addCell((Object)"index", "default:true;alias:i,idx;desc:index name").addCell((Object)"shard", "default:true;alias:s,sh;desc:shard name").addCell((Object)"prirep", "alias:p,pr,primaryOrReplica;default:true;desc:primary or replica").addCell((Object)"state", "default:true;alias:st;desc:shard state").addCell((Object)"docs", "alias:d,dc;text-align:right;desc:number of docs in shard").addCell((Object)"store", "alias:sto;text-align:right;desc:store size of shard (how much disk it uses)").addCell((Object)"ip", "default:true;desc:ip of node where it lives").addCell((Object)"id", "default:false;desc:unique id of node where it lives").addCell((Object)"node", "default:true;alias:n;desc:name of node where it lives");
        table.addCell((Object)"sync_id", "alias:sync_id;default:false;desc:sync id");
        table.addCell((Object)"unassigned.reason", "alias:ur;default:false;desc:reason shard is unassigned");
        table.addCell((Object)"unassigned.at", "alias:ua;default:false;desc:time shard became unassigned (UTC)");
        table.addCell((Object)"unassigned.for", "alias:uf;default:false;text-align:right;desc:time has been unassigned");
        table.addCell((Object)"unassigned.details", "alias:ud;default:false;desc:additional details as to why the shard became unassigned");
        table.addCell((Object)"recoverysource.type", "alias:rs;default:false;desc:recovery source type");
        table.addCell((Object)"completion.size", "alias:cs,completionSize;default:false;text-align:right;desc:size of completion");
        table.addCell((Object)"fielddata.memory_size", "alias:fm,fielddataMemory;default:false;text-align:right;desc:used fielddata cache");
        table.addCell((Object)"fielddata.evictions", "alias:fe,fielddataEvictions;default:false;text-align:right;desc:fielddata evictions");
        table.addCell((Object)"query_cache.memory_size", "alias:qcm,queryCacheMemory;default:false;text-align:right;desc:used query cache");
        table.addCell((Object)"query_cache.evictions", "alias:qce,queryCacheEvictions;default:false;text-align:right;desc:query cache evictions");
        table.addCell((Object)"flush.total", "alias:ft,flushTotal;default:false;text-align:right;desc:number of flushes");
        table.addCell((Object)"flush.total_time", "alias:ftt,flushTotalTime;default:false;text-align:right;desc:time spent in flush");
        table.addCell((Object)"get.current", "alias:gc,getCurrent;default:false;text-align:right;desc:number of current get ops");
        table.addCell((Object)"get.time", "alias:gti,getTime;default:false;text-align:right;desc:time spent in get");
        table.addCell((Object)"get.total", "alias:gto,getTotal;default:false;text-align:right;desc:number of get ops");
        table.addCell((Object)"get.exists_time", "alias:geti,getExistsTime;default:false;text-align:right;desc:time spent in successful gets");
        table.addCell((Object)"get.exists_total", "alias:geto,getExistsTotal;default:false;text-align:right;desc:number of successful gets");
        table.addCell((Object)"get.missing_time", "alias:gmti,getMissingTime;default:false;text-align:right;desc:time spent in failed gets");
        table.addCell((Object)"get.missing_total", "alias:gmto,getMissingTotal;default:false;text-align:right;desc:number of failed gets");
        table.addCell((Object)"indexing.delete_current", "alias:idc,indexingDeleteCurrent;default:false;text-align:right;desc:number of current deletions");
        table.addCell((Object)"indexing.delete_time", "alias:idti,indexingDeleteTime;default:false;text-align:right;desc:time spent in deletions");
        table.addCell((Object)"indexing.delete_total", "alias:idto,indexingDeleteTotal;default:false;text-align:right;desc:number of delete ops");
        table.addCell((Object)"indexing.index_current", "alias:iic,indexingIndexCurrent;default:false;text-align:right;desc:number of current indexing ops");
        table.addCell((Object)"indexing.index_time", "alias:iiti,indexingIndexTime;default:false;text-align:right;desc:time spent in indexing");
        table.addCell((Object)"indexing.index_total", "alias:iito,indexingIndexTotal;default:false;text-align:right;desc:number of indexing ops");
        table.addCell((Object)"indexing.index_failed", "alias:iif,indexingIndexFailed;default:false;text-align:right;desc:number of failed indexing ops");
        table.addCell((Object)"merges.current", "alias:mc,mergesCurrent;default:false;text-align:right;desc:number of current merges");
        table.addCell((Object)"merges.current_docs", "alias:mcd,mergesCurrentDocs;default:false;text-align:right;desc:number of current merging docs");
        table.addCell((Object)"merges.current_size", "alias:mcs,mergesCurrentSize;default:false;text-align:right;desc:size of current merges");
        table.addCell((Object)"merges.total", "alias:mt,mergesTotal;default:false;text-align:right;desc:number of completed merge ops");
        table.addCell((Object)"merges.total_docs", "alias:mtd,mergesTotalDocs;default:false;text-align:right;desc:docs merged");
        table.addCell((Object)"merges.total_size", "alias:mts,mergesTotalSize;default:false;text-align:right;desc:size merged");
        table.addCell((Object)"merges.total_time", "alias:mtt,mergesTotalTime;default:false;text-align:right;desc:time spent in merges");
        table.addCell((Object)"refresh.total", "alias:rto,refreshTotal;default:false;text-align:right;desc:total refreshes");
        table.addCell((Object)"refresh.time", "alias:rti,refreshTime;default:false;text-align:right;desc:time spent in refreshes");
        table.addCell((Object)"refresh.external_total", "alias:rto,refreshTotal;default:false;text-align:right;desc:total external refreshes");
        table.addCell((Object)"refresh.external_time", "alias:rti,refreshTime;default:false;text-align:right;desc:time spent in external refreshes");
        table.addCell((Object)"refresh.listeners", "alias:rli,refreshListeners;default:false;text-align:right;desc:number of pending refresh listeners");
        table.addCell((Object)"search.fetch_current", "alias:sfc,searchFetchCurrent;default:false;text-align:right;desc:current fetch phase ops");
        table.addCell((Object)"search.fetch_time", "alias:sfti,searchFetchTime;default:false;text-align:right;desc:time spent in fetch phase");
        table.addCell((Object)"search.fetch_total", "alias:sfto,searchFetchTotal;default:false;text-align:right;desc:total fetch ops");
        table.addCell((Object)"search.open_contexts", "alias:so,searchOpenContexts;default:false;text-align:right;desc:open search contexts");
        table.addCell((Object)"search.query_current", "alias:sqc,searchQueryCurrent;default:false;text-align:right;desc:current query phase ops");
        table.addCell((Object)"search.query_time", "alias:sqti,searchQueryTime;default:false;text-align:right;desc:time spent in query phase");
        table.addCell((Object)"search.query_total", "alias:sqto,searchQueryTotal;default:false;text-align:right;desc:total query phase ops");
        if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled")) {
            table.addCell((Object)"search.concurrent_query_current", "alias:scqc,searchConcurrentQueryCurrent;default:false;text-align:right;desc:current concurrent query phase ops");
            table.addCell((Object)"search.concurrent_query_time", "alias:scqti,searchConcurrentQueryTime;default:false;text-align:right;desc:time spent in concurrent query phase");
            table.addCell((Object)"search.concurrent_query_total", "alias:scqto,searchConcurrentQueryTotal;default:false;text-align:right;desc:total concurrent query phase ops");
            table.addCell((Object)"search.concurrent_avg_slice_count", "alias:casc,searchConcurrentAvgSliceCount;default:false;text-align:right;desc:average query concurrency");
        }
        table.addCell((Object)"search.scroll_current", "alias:scc,searchScrollCurrent;default:false;text-align:right;desc:open scroll contexts");
        table.addCell((Object)"search.scroll_time", "alias:scti,searchScrollTime;default:false;text-align:right;desc:time scroll contexts held open");
        table.addCell((Object)"search.scroll_total", "alias:scto,searchScrollTotal;default:false;text-align:right;desc:completed scroll contexts");
        table.addCell((Object)"search.point_in_time_current", "alias:spc,searchPointInTimeCurrent;default:false;text-align:right;desc:open point in time contexts");
        table.addCell((Object)"search.point_in_time_time", "alias:spti,searchPointInTimeTime;default:false;text-align:right;desc:time point in time contexts held open");
        table.addCell((Object)"search.point_in_time_total", "alias:spto,searchPointInTimeTotal;default:false;text-align:right;desc:completed point in time contexts");
        table.addCell((Object)"segments.count", "alias:sc,segmentsCount;default:false;text-align:right;desc:number of segments");
        table.addCell((Object)"segments.memory", "alias:sm,segmentsMemory;default:false;text-align:right;desc:memory used by segments");
        table.addCell((Object)"segments.index_writer_memory", "alias:siwm,segmentsIndexWriterMemory;default:false;text-align:right;desc:memory used by index writer");
        table.addCell((Object)"segments.version_map_memory", "alias:svmm,segmentsVersionMapMemory;default:false;text-align:right;desc:memory used by version map");
        table.addCell((Object)"segments.fixed_bitset_memory", "alias:sfbm,fixedBitsetMemory;default:false;text-align:right;desc:memory used by fixed bit sets for nested object field types and type filters for types referred in _parent fields");
        table.addCell((Object)"seq_no.max", "alias:sqm,maxSeqNo;default:false;text-align:right;desc:max sequence number");
        table.addCell((Object)"seq_no.local_checkpoint", "alias:sql,localCheckpoint;default:false;text-align:right;desc:local checkpoint");
        table.addCell((Object)"seq_no.global_checkpoint", "alias:sqg,globalCheckpoint;default:false;text-align:right;desc:global checkpoint");
        table.addCell((Object)"warmer.current", "alias:wc,warmerCurrent;default:false;text-align:right;desc:current warmer ops");
        table.addCell((Object)"warmer.total", "alias:wto,warmerTotal;default:false;text-align:right;desc:total warmer ops");
        table.addCell((Object)"warmer.total_time", "alias:wtt,warmerTotalTime;default:false;text-align:right;desc:time spent in warmers");
        table.addCell((Object)"path.data", "alias:pd,dataPath;default:false;text-align:right;desc:shard data path");
        table.addCell((Object)"path.state", "alias:ps,statsPath;default:false;text-align:right;desc:shard state path");
        table.endHeaders();
        return table;
    }

    private static <S, T> Object getOrNull(S stats, Function<S, T> accessor, Function<T, Object> func) {
        T t;
        if (stats != null && (t = accessor.apply(stats)) != null) {
            return func.apply(t);
        }
        return null;
    }

    Table buildTable(RestRequest request, ClusterStateResponse state, IndicesStatsResponse stats) {
        Table table = this.getTableWithHeader(request);
        for (ShardRouting shard : state.getState().routingTable().allShards()) {
            ShardStats shardStats = (ShardStats)stats.asMap().get(shard);
            CommonStats commonStats = null;
            CommitStats commitStats = null;
            if (shardStats != null) {
                commonStats = shardStats.getStats();
                commitStats = shardStats.getCommitStats();
            }
            table.startRow();
            table.addCell((Object)shard.getIndexName());
            table.addCell((Object)shard.id());
            if (shard.primary()) {
                table.addCell((Object)"p");
            } else {
                table.addCell((Object)"r");
            }
            table.addCell((Object)shard.state());
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getDocs, DocsStats::getCount));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getStore, StoreStats::getSize));
            if (shard.assignedToNode()) {
                String ip = state.getState().nodes().get(shard.currentNodeId()).getHostAddress();
                String nodeId = shard.currentNodeId();
                StringBuilder name = new StringBuilder();
                name.append(state.getState().nodes().get(shard.currentNodeId()).getName());
                if (shard.relocating()) {
                    String reloIp = state.getState().nodes().get(shard.relocatingNodeId()).getHostAddress();
                    String reloNme = state.getState().nodes().get(shard.relocatingNodeId()).getName();
                    String reloNodeId = shard.relocatingNodeId();
                    name.append(" -> ");
                    name.append(reloIp);
                    name.append(" ");
                    name.append(reloNodeId);
                    name.append(" ");
                    name.append(reloNme);
                }
                table.addCell((Object)ip);
                table.addCell((Object)nodeId);
                table.addCell((Object)name);
            } else {
                table.addCell(null);
                table.addCell(null);
                table.addCell(null);
            }
            table.addCell(commitStats == null ? null : commitStats.getUserData().get("sync_id"));
            if (shard.unassignedInfo() != null) {
                table.addCell((Object)shard.unassignedInfo().getReason());
                Instant unassignedTime = Instant.ofEpochMilli(shard.unassignedInfo().getUnassignedTimeInMillis());
                table.addCell((Object)UnassignedInfo.DATE_TIME_FORMATTER.format((TemporalAccessor)unassignedTime));
                table.addCell((Object)TimeValue.timeValueMillis((long)(System.currentTimeMillis() - shard.unassignedInfo().getUnassignedTimeInMillis())));
                table.addCell((Object)shard.unassignedInfo().getDetails());
            } else {
                table.addCell(null);
                table.addCell(null);
                table.addCell(null);
                table.addCell(null);
            }
            if (shard.recoverySource() != null) {
                table.addCell((Object)shard.recoverySource().getType().toString().toLowerCase(Locale.ROOT));
            } else {
                table.addCell(null);
            }
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getCompletion, CompletionStats::getSize));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getFieldData, FieldDataStats::getMemorySize));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getFieldData, FieldDataStats::getEvictions));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getQueryCache, QueryCacheStats::getMemorySize));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getQueryCache, QueryCacheStats::getEvictions));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getFlush, FlushStats::getTotal));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getFlush, FlushStats::getTotalTime));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getGet, GetStats::current));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getGet, GetStats::getTime));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getGet, GetStats::getCount));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getGet, GetStats::getExistsTime));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getGet, GetStats::getExistsCount));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getGet, GetStats::getMissingTime));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getGet, GetStats::getMissingCount));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getIndexing, i -> i.getTotal().getDeleteCurrent()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getIndexing, i -> i.getTotal().getDeleteTime()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getIndexing, i -> i.getTotal().getDeleteCount()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getIndexing, i -> i.getTotal().getIndexCurrent()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getIndexing, i -> i.getTotal().getIndexTime()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getIndexing, i -> i.getTotal().getIndexCount()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getIndexing, i -> i.getTotal().getIndexFailedCount()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getCurrent));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getCurrentNumDocs));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getCurrentSize));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotal));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotalNumDocs));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotalSize));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotalTime));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getRefresh, RefreshStats::getTotal));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getRefresh, RefreshStats::getTotalTime));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getRefresh, RefreshStats::getExternalTotal));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getRefresh, RefreshStats::getExternalTotalTime));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getRefresh, RefreshStats::getListeners));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getFetchCurrent()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getFetchTime()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getFetchCount()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, SearchStats::getOpenContexts));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getQueryCurrent()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getQueryTime()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getQueryCount()));
            if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled")) {
                table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getConcurrentQueryCurrent()));
                table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getConcurrentQueryTime()));
                table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getConcurrentQueryCount()));
                table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getConcurrentAvgSliceCount()));
            }
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getScrollCurrent()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getScrollTime()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getScrollCount()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getPitCurrent()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getPitTime()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSearch, i -> i.getTotal().getPitCount()));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getCount));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getZeroMemory));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getIndexWriterMemory));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getVersionMapMemory));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getBitsetMemory));
            table.addCell(RestShardsAction.getOrNull(shardStats, ShardStats::getSeqNoStats, SeqNoStats::getMaxSeqNo));
            table.addCell(RestShardsAction.getOrNull(shardStats, ShardStats::getSeqNoStats, SeqNoStats::getLocalCheckpoint));
            table.addCell(RestShardsAction.getOrNull(shardStats, ShardStats::getSeqNoStats, SeqNoStats::getGlobalCheckpoint));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getWarmer, WarmerStats::current));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getWarmer, WarmerStats::total));
            table.addCell(RestShardsAction.getOrNull(commonStats, CommonStats::getWarmer, WarmerStats::totalTime));
            table.addCell(RestShardsAction.getOrNull(shardStats, ShardStats::getDataPath, s -> s));
            table.addCell(RestShardsAction.getOrNull(shardStats, ShardStats::getStatePath, s -> s));
            table.endRow();
        }
        return table;
    }
}

