/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.IndexTemplateMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestTemplatesAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestTemplatesAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/templates"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/templates/{name}")));
    }

    @Override
    public String getName() {
        return "cat_templates_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/templates\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        final String matchPattern = request.hasParam("name") ? request.param("name") : null;
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().metadata(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestTemplatesAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestResponseListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse clusterStateResponse) throws Exception {
                return RestTable.buildResponse(RestTemplatesAction.this.buildTable(request, clusterStateResponse, matchPattern), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"name", "alias:n;desc:template name");
        table.addCell((Object)"index_patterns", "alias:t;desc:template index patterns");
        table.addCell((Object)"order", "alias:o,p;desc:template application order/priority number");
        table.addCell((Object)"version", "alias:v;desc:version");
        table.addCell((Object)"composed_of", "alias:c;desc:component templates comprising index template");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse clusterStateResponse, String patternString) {
        Table table = this.getTableWithHeader(request);
        Metadata metadata = clusterStateResponse.getState().metadata();
        for (IndexTemplateMetadata indexTemplateMetadata : metadata.templates().values()) {
            if (patternString != null && !Regex.simpleMatch((String)patternString, (String)indexTemplateMetadata.name())) continue;
            table.startRow();
            table.addCell((Object)indexTemplateMetadata.name());
            table.addCell((Object)("[" + String.join((CharSequence)", ", indexTemplateMetadata.patterns()) + "]"));
            table.addCell((Object)indexTemplateMetadata.getOrder());
            table.addCell((Object)indexTemplateMetadata.getVersion());
            table.addCell((Object)"");
            table.endRow();
        }
        for (Map.Entry entry : metadata.templatesV2().entrySet()) {
            String name = (String)entry.getKey();
            ComposableIndexTemplate template = (ComposableIndexTemplate)entry.getValue();
            if (patternString != null && !Regex.simpleMatch((String)patternString, (String)name)) continue;
            table.startRow();
            table.addCell((Object)name);
            table.addCell((Object)("[" + String.join((CharSequence)", ", template.indexPatterns()) + "]"));
            table.addCell((Object)template.priorityOrZero());
            table.addCell((Object)template.version());
            table.addCell((Object)("[" + String.join((CharSequence)", ", template.composedOf()) + "]"));
            table.endRow();
        }
        return table;
    }
}

