/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkShardRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestBulkAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    public RestBulkAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/_bulk"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_bulk")));
    }

    @Override
    public String getName() {
        return "bulk_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        String defaultIndex = request.param("index");
        String defaultRouting = request.param("routing");
        FetchSourceContext defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest((RestRequest)request);
        String defaultPipeline = request.param("pipeline");
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            bulkRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        Boolean defaultRequireAlias = request.paramAsBoolean("require_alias", null);
        bulkRequest.timeout(request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT));
        bulkRequest.setRefreshPolicy(request.param("refresh"));
        bulkRequest.add(request.requiredContent(), defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, this.allowExplicitIndex, request.getMediaType());
        return channel -> client.bulk(bulkRequest, new RestStatusToXContentListener((RestChannel)channel));
    }

    public boolean supportsContentStream() {
        return true;
    }

    public boolean allowsUnsafeBuffers() {
        return true;
    }
}

