/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.index.VersionType;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "document_get_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_doc/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_doc/{id}")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] fields;
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("id"));
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("the parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or [_source] to load the field from _source");
        }
        String fieldsParam = request.param("stored_fields");
        if (fieldsParam != null && (fields = Strings.splitStringByCommaToArray((String)fieldsParam)) != null) {
            getRequest.storedFields(fields);
        }
        getRequest.version(RestActions.parseVersion(request));
        getRequest.versionType(VersionType.fromString((String)request.param("version_type"), (VersionType)getRequest.versionType()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest((RestRequest)request));
        return channel -> client.get(getRequest, (ActionListener)new RestToXContentListener<GetResponse>(this, channel){

            @Override
            protected RestStatus getStatus(GetResponse response) {
                return response.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }
}

