/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMultiGetAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    public RestMultiGetAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mget"), new RestHandler.Route(RestRequest.Method.POST, "/_mget"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mget"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mget")));
    }

    @Override
    public String getName() {
        return "document_mget_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        multiGetRequest.refresh(request.paramAsBoolean("refresh", multiGetRequest.refresh()));
        multiGetRequest.preference(request.param("preference"));
        multiGetRequest.realtime(request.paramAsBoolean("realtime", multiGetRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or _source filtering if the field is not stored");
        }
        String[] sFields = null;
        String sField = request.param("stored_fields");
        if (sField != null) {
            sFields = Strings.splitStringByCommaToArray((String)sField);
        }
        FetchSourceContext defaultFetchSource = FetchSourceContext.parseFromRestRequest((RestRequest)request);
        try (XContentParser parser = request.contentOrSourceParamParser();){
            multiGetRequest.add(request.param("index"), sFields, defaultFetchSource, request.param("routing"), parser, this.allowExplicitIndex);
        }
        return channel -> client.multiGet(multiGetRequest, new RestToXContentListener((RestChannel)channel));
    }
}

