/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import io.skylite.core.action.termvectors.TermVectorsRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.index.VersionType;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;

public class RestTermVectorsAction
extends BaseRestHandler {
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in term vector requests is deprecated.";

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_termvectors"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_termvectors"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_termvectors/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_termvectors/{id}")));
    }

    @Override
    public String getName() {
        return "document_term_vectors_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        TermVectorsRequest termVectorsRequest = new TermVectorsRequest(request.param("index"), request.param("id"));
        if (request.hasContentOrSourceParam()) {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                TermVectorsRequest.parseRequest((TermVectorsRequest)termVectorsRequest, (XContentParser)parser);
            }
        }
        RestTermVectorsAction.readURIParameters(termVectorsRequest, request);
        return channel -> client.termVectors(termVectorsRequest, new RestToXContentListener((RestChannel)channel));
    }

    public static void readURIParameters(TermVectorsRequest termVectorsRequest, RestRequest request) {
        String fields = request.param("fields");
        RestTermVectorsAction.addFieldStringsFromParameter(termVectorsRequest, fields);
        termVectorsRequest.offsets(request.paramAsBoolean("offsets", termVectorsRequest.offsets()));
        termVectorsRequest.positions(request.paramAsBoolean("positions", termVectorsRequest.positions()));
        termVectorsRequest.payloads(request.paramAsBoolean("payloads", termVectorsRequest.payloads()));
        termVectorsRequest.routing(request.param("routing"));
        termVectorsRequest.realtime(request.paramAsBoolean("realtime", termVectorsRequest.realtime()));
        termVectorsRequest.version(RestActions.parseVersion(request, termVectorsRequest.version()));
        termVectorsRequest.versionType(VersionType.fromString((String)request.param("version_type"), (VersionType)termVectorsRequest.versionType()));
        termVectorsRequest.preference(request.param("preference"));
        termVectorsRequest.termStatistics(request.paramAsBoolean("termStatistics", termVectorsRequest.termStatistics()));
        termVectorsRequest.termStatistics(request.paramAsBoolean("term_statistics", termVectorsRequest.termStatistics()));
        termVectorsRequest.fieldStatistics(request.paramAsBoolean("fieldStatistics", termVectorsRequest.fieldStatistics()));
        termVectorsRequest.fieldStatistics(request.paramAsBoolean("field_statistics", termVectorsRequest.fieldStatistics()));
    }

    public static void addFieldStringsFromParameter(TermVectorsRequest termVectorsRequest, String fields) {
        HashSet<String> selectedFields = termVectorsRequest.selectedFields();
        if (fields != null) {
            String[] paramFieldStrings;
            for (String field : paramFieldStrings = Strings.commaDelimitedListToStringArray((String)fields)) {
                if (selectedFields == null) {
                    selectedFields = new HashSet<String>();
                }
                if (selectedFields.contains(field)) continue;
                field = field.replaceAll("\\s", "");
                selectedFields.add(field);
            }
        }
        if (selectedFields != null) {
            termVectorsRequest.selectedFields(selectedFields.toArray(new String[0]));
        }
    }
}

