/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.index.VersionType;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestUpdateAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_update/{id}")));
    }

    @Override
    public String getName() {
        return "document_update_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(request.param("index"), request.param("id"));
        updateRequest.routing(request.param("routing"));
        updateRequest.timeout(request.paramAsTime("timeout", updateRequest.timeout()));
        updateRequest.setRefreshPolicy(request.param("refresh"));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            updateRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        updateRequest.docAsUpsert(request.paramAsBoolean("doc_as_upsert", updateRequest.docAsUpsert()));
        FetchSourceContext fetchSourceContext = FetchSourceContext.parseFromRestRequest((RestRequest)request);
        if (fetchSourceContext != null) {
            updateRequest.fetchSource(fetchSourceContext);
        }
        updateRequest.retryOnConflict(request.paramAsInt("retry_on_conflict", updateRequest.retryOnConflict()));
        if (request.hasParam("version") || request.hasParam("version_type")) {
            ActionRequestValidationException versioningError = new ActionRequestValidationException();
            versioningError.addValidationError("internal versioning can not be used for optimistic concurrency control. Please use `if_seq_no` and `if_primary_term` instead");
            throw versioningError;
        }
        updateRequest.setIfSeqNo(request.paramAsLong("if_seq_no", updateRequest.ifSeqNo()));
        updateRequest.setIfPrimaryTerm(request.paramAsLong("if_primary_term", updateRequest.ifPrimaryTerm()));
        updateRequest.setRequireAlias(request.paramAsBoolean("require_alias", updateRequest.isRequireAlias()));
        request.applyContentParser(parser -> {
            IndexRequest doc;
            updateRequest.fromXContent(parser);
            IndexRequest upsertRequest = updateRequest.upsertRequest();
            if (upsertRequest != null) {
                upsertRequest.routing(request.param("routing"));
                upsertRequest.version(RestActions.parseVersion(request));
                upsertRequest.versionType(VersionType.fromString((String)request.param("version_type"), (VersionType)upsertRequest.versionType()));
            }
            if ((doc = updateRequest.doc()) != null) {
                doc.routing(request.param("routing"));
                doc.version(RestActions.parseVersion(request));
                doc.versionType(VersionType.fromString((String)request.param("version_type"), (VersionType)doc.versionType()));
            }
        });
        return channel -> client.update(updateRequest, new RestStatusToXContentListener<UpdateResponse>((RestChannel)channel, r -> r.getLocation(updateRequest.routing())));
    }
}

