/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.ingest;

import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.ingest.DeletePipelineRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDeletePipelineAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestDeletePipelineAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_ingest/pipeline/{id}"));
    }

    @Override
    public String getName() {
        return "ingest_delete_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        DeletePipelineRequest request = new DeletePipelineRequest(restRequest.param("id"));
        request.clusterManagerNodeTimeout(restRequest.paramAsTime("cluster_manager_timeout", request.clusterManagerNodeTimeout()));
        RestDeletePipelineAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)request, restRequest, deprecationLogger, this.getName());
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        return channel -> client.admin().cluster().deletePipeline(request, new RestToXContentListener((RestChannel)channel));
    }
}

