/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.ingest;

import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.ingest.GetPipelineRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestGetPipelineAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetPipelineAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_ingest/pipeline"), new RestHandler.Route(RestRequest.Method.GET, "/_ingest/pipeline/{id}")));
    }

    @Override
    public String getName() {
        return "ingest_get_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetPipelineRequest request = new GetPipelineRequest(Strings.splitStringByCommaToArray((String)restRequest.param("id")));
        request.clusterManagerNodeTimeout(restRequest.paramAsTime("cluster_manager_timeout", request.clusterManagerNodeTimeout()));
        RestGetPipelineAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)request, restRequest, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().getPipeline(request, new RestStatusToXContentListener((RestChannel)channel));
    }
}

