/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import io.skylite.common.CheckedBiConsumer;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.MultiSearchAction;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestCancellableNodeClient;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.search.RestSearchAction;

public class RestMultiSearchAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestMultiSearchAction.class);
    private static final Set<String> RESPONSE_PARAMS;
    private final boolean allowExplicitIndex;

    public RestMultiSearchAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_msearch"), new RestHandler.Route(RestRequest.Method.POST, "/_msearch"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_msearch"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_msearch")));
    }

    @Override
    public String getName() {
        return "msearch_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchRequest multiSearchRequest = RestMultiSearchAction.parseRequest(request, client.getNamedWriteableRegistry(), this.allowExplicitIndex);
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)MultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, new RestToXContentListener((RestChannel)channel));
        };
    }

    public static MultiSearchRequest parseRequest(RestRequest restRequest, NamedWriteableRegistry namedWriteableRegistry, boolean allowExplicitIndex) throws IOException {
        MultiSearchRequest multiRequest = new MultiSearchRequest();
        IndicesOptions indicesOptions = IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)multiRequest.indicesOptions());
        multiRequest.indicesOptions(indicesOptions);
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        Integer preFilterShardSize = null;
        if (restRequest.hasParam("pre_filter_shard_size")) {
            preFilterShardSize = restRequest.paramAsInt("pre_filter_shard_size", 128);
        }
        Integer maxConcurrentShardRequests = restRequest.hasParam("max_concurrent_shard_requests") ? Integer.valueOf(restRequest.paramAsInt("max_concurrent_shard_requests", Integer.MIN_VALUE)) : null;
        RestMultiSearchAction.parseMultiLineRequest(restRequest, multiRequest.indicesOptions(), allowExplicitIndex, (CheckedBiConsumer<SearchRequest, XContentParser, IOException>)((CheckedBiConsumer)(searchRequest, parser) -> {
            searchRequest.source(SearchSourceBuilder.fromXContent((XContentParser)parser, (boolean)false));
            RestSearchAction.checkRestTotalHits(restRequest, searchRequest);
            if (searchRequest.pointInTimeBuilder() != null) {
                RestSearchAction.preparePointInTime(searchRequest, restRequest, namedWriteableRegistry);
            } else {
                searchRequest.setCcsMinimizeRoundtrips(restRequest.paramAsBoolean("ccs_minimize_roundtrips", searchRequest.isCcsMinimizeRoundtrips()));
            }
            multiRequest.add(searchRequest);
        }));
        List requests = multiRequest.requests();
        TimeValue cancelAfterTimeInterval = restRequest.paramAsTime("cancel_after_time_interval", null);
        for (SearchRequest request : requests) {
            if (preFilterShardSize != null && request.getPreFilterShardSize() == null) {
                request.setPreFilterShardSize(preFilterShardSize.intValue());
            }
            if (maxConcurrentShardRequests != null) {
                request.setMaxConcurrentShardRequests(maxConcurrentShardRequests.intValue());
            }
            if (request.getCancelAfterTimeInterval() != null) continue;
            request.setCancelAfterTimeInterval(cancelAfterTimeInterval);
        }
        return multiRequest;
    }

    public static void parseMultiLineRequest(RestRequest request, IndicesOptions indicesOptions, boolean allowExplicitIndex, CheckedBiConsumer<SearchRequest, XContentParser, IOException> consumer) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        String searchType = request.param("search_type");
        boolean ccsMinimizeRoundtrips = request.paramAsBoolean("ccs_minimize_roundtrips", true);
        String routing = request.param("routing");
        Tuple sourceTuple = request.contentOrSourceParam();
        XContent xContent = ((MediaType)sourceTuple.v1()).xContent();
        BytesReference data = (BytesReference)sourceTuple.v2();
        MultiSearchRequest.readMultiLineFormat((BytesReference)data, (XContent)xContent, consumer, (String[])indices, (IndicesOptions)indicesOptions, (String)routing, (String)searchType, (Boolean)ccsMinimizeRoundtrips, (NamedXContentRegistry)request.getXContentRegistry(), (boolean)allowExplicitIndex, (DeprecationLogger)deprecationLogger);
    }

    public boolean supportsContentStream() {
        return true;
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

