/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import io.skylite.common.collect.Tuple;
import io.skylite.core.action.search.PutSearchPipelineRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.MediaType;
import java.io.IOException;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestPutSearchPipelineAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "search_put_pipeline_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_search/pipeline/{id}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        Tuple sourceTuple = restRequest.contentOrSourceParam();
        PutSearchPipelineRequest request = new PutSearchPipelineRequest(restRequest.param("id"), (BytesReference)sourceTuple.v2(), (MediaType)sourceTuple.v1());
        request.clusterManagerNodeTimeout(restRequest.paramAsTime("cluster_manager_timeout", request.clusterManagerNodeTimeout()));
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        return channel -> client.admin().cluster().putSearchPipeline(request, new RestToXContentListener((RestChannel)channel));
    }
}

