/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.Scroll;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestSearchScrollAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("rest_total_hits_as_int");

    @Override
    public String getName() {
        return "search_scroll_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_search/scroll"), new RestHandler.Route(RestRequest.Method.POST, "/_search/scroll"), new RestHandler.Route(RestRequest.Method.GET, "/_search/scroll/{scroll_id}"), new RestHandler.Route(RestRequest.Method.POST, "/_search/scroll/{scroll_id}")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scrollId = request.param("scroll_id");
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest();
        searchScrollRequest.scrollId(scrollId);
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll")));
        }
        request.withContentOrSourceParamParserOrNull(xContentParser -> {
            if (xContentParser != null) {
                try {
                    searchScrollRequest.fromXContent(xContentParser);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse request body", e);
                }
            }
        });
        return channel -> client.searchScroll(searchScrollRequest, new RestStatusToXContentListener((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

