/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import io.skylite.SkyliteException;
import io.skylite.common.MutatingMap;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptFactory;
import io.skylite.core.search.lookup.LeafSearchLookup;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;

public class ScriptedMetricAggContexts {

    public static abstract class ReduceScript {
        private final Map<String, Object> params;
        private final List<Object> states;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext("aggs_reduce", Factory.class);

        public ReduceScript(Map<String, Object> params, List<Object> states) {
            this.params = params;
            this.states = states;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public List<Object> getStates() {
            return this.states;
        }

        public abstract Object execute();

        public static interface Factory
        extends ScriptFactory {
            public ReduceScript newInstance(Map<String, Object> var1, List<Object> var2);
        }
    }

    public static abstract class CombineScript {
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext("aggs_combine", Factory.class);

        public CombineScript(Map<String, Object> params, Map<String, Object> state) {
            this.params = params;
            this.state = state;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getState() {
            return this.state;
        }

        public abstract Object execute();

        public static interface Factory
        extends ScriptFactory {
            public CombineScript newInstance(Map<String, Object> var1, Map<String, Object> var2);
        }
    }

    public static abstract class MapScript {
        private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MutatingMap.class);
        private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
            deprecationLogger.deprecate("map-script_doc", "Accessing variable [doc] via [params.doc] from within an scripted metric agg map script is deprecated in favor of directly accessing [doc].", new Object[0]);
            return value;
        }, "_doc", value -> {
            deprecationLogger.deprecate("map-script__doc", "Accessing variable [doc] via [params._doc] from within an scripted metric agg map script is deprecated in favor of directly accessing [doc].", new Object[0]);
            return value;
        }, "_agg", value -> {
            deprecationLogger.deprecate("map-script__agg", "Accessing variable [_agg] via [params._agg] from within a scripted metric agg map script is deprecated in favor of using [state].", new Object[0]);
            return value;
        }, "_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        private final LeafSearchLookup leafLookup;
        private Scorable scorer;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext("aggs_map", Factory.class);

        public MapScript(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup, LeafReaderContext leafContext) {
            this.state = state;
            LeafSearchLookup leafSearchLookup = this.leafLookup = leafContext == null ? null : lookup.getLeafSearchLookup(leafContext);
            if (this.leafLookup != null) {
                params = new HashMap<String, Object>((Map<String, Object>)params);
                params.putAll(this.leafLookup.asMap());
                params = new MutatingMap(params, PARAMS_FUNCTIONS);
            }
            this.params = params;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getState() {
            return this.state;
        }

        public Map<String, ScriptDocValues<?>> getDoc() {
            return this.leafLookup == null ? null : this.leafLookup.doc();
        }

        public void setDocument(int docId) {
            if (this.leafLookup != null) {
                this.leafLookup.setDocument(docId);
            }
        }

        public void setScorer(Scorable scorer) {
            this.scorer = scorer;
        }

        public double get_score() {
            if (this.scorer == null) {
                return 0.0;
            }
            try {
                return this.scorer.score();
            }
            catch (IOException e) {
                throw new SkyliteException("Couldn't look up score", (Throwable)e, new Object[0]);
            }
        }

        public abstract void execute();

        public static interface Factory
        extends ScriptFactory {
            public LeafFactory newFactory(Map<String, Object> var1, Map<String, Object> var2, SearchLookup var3);
        }

        public static interface LeafFactory {
            public MapScript newInstance(LeafReaderContext var1);
        }
    }

    public static abstract class InitScript {
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext("aggs_init", Factory.class);

        public InitScript(Map<String, Object> params, Map<String, Object> state) {
            this.params = params;
            this.state = state;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Object getState() {
            return this.state;
        }

        public abstract void execute();

        public static interface Factory
        extends ScriptFactory {
            public InitScript newInstance(Map<String, Object> var1, Map<String, Object> var2);
        }
    }
}

