/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import io.lucenia.plugins.SearchPlugin;
import io.skylite.common.CheckedFunction;
import io.skylite.common.NamedRegistry;
import io.skylite.common.Nullable;
import io.skylite.common.collect.Tuple;
import io.skylite.core.FeatureFlags;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.BaseAggregationBuilder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.PipelineAggregationBuilder;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.geo.DocValueGeoFormatters;
import io.skylite.core.index.fielddata.DocValueDateFormatters;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.DisMaxQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.FieldMaskingSpanQueryBuilder;
import io.skylite.core.index.query.FuzzyQueryBuilder;
import io.skylite.core.index.query.IdsQueryBuilder;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.MatchBoolPrefixQueryBuilder;
import io.skylite.core.index.query.MatchNoneQueryBuilder;
import io.skylite.core.index.query.MatchPhrasePrefixQueryBuilder;
import io.skylite.core.index.query.MatchPhraseQueryBuilder;
import io.skylite.core.index.query.MatchQueryBuilder;
import io.skylite.core.index.query.MultiMatchQueryBuilder;
import io.skylite.core.index.query.PrefixQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.query.RegexpQueryBuilder;
import io.skylite.core.index.query.SimpleQueryStringBuilder;
import io.skylite.core.index.query.SpanContainingQueryBuilder;
import io.skylite.core.index.query.SpanFirstQueryBuilder;
import io.skylite.core.index.query.SpanNearQueryBuilder;
import io.skylite.core.index.query.SpanNotQueryBuilder;
import io.skylite.core.index.query.SpanOrQueryBuilder;
import io.skylite.core.index.query.SpanTermQueryBuilder;
import io.skylite.core.index.query.SpanWithinQueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.index.query.WildcardQueryBuilder;
import io.skylite.core.index.query.functionscore.FunctionScoreQueryBuilder;
import io.skylite.core.index.query.functionscore.ScoreFunctionBuilder;
import io.skylite.core.index.query.functionscore.WeightBuilder;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.search.query.QueryPhase;
import io.skylite.core.search.query.QueryPhaseSearcher;
import io.skylite.core.search.query.QueryPhaseSearcherWrapper;
import io.skylite.core.search.rescore.QueryRescorerBuilder;
import io.skylite.core.search.rescore.RescorerBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.SortValue;
import io.skylite.core.search.sort.spi.SortBuilderProvider;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.search.suggest.SuggestionBuilder;
import io.skylite.core.search.suggest.completion.CompletionSuggestion;
import io.skylite.core.search.suggest.completion.CompletionSuggestionBuilder;
import io.skylite.core.search.suggest.phrase.Laplace;
import io.skylite.core.search.suggest.phrase.LinearInterpolation;
import io.skylite.core.search.suggest.phrase.PhraseSuggestion;
import io.skylite.core.search.suggest.phrase.PhraseSuggestionBuilder;
import io.skylite.core.search.suggest.phrase.SmoothingModel;
import io.skylite.core.search.suggest.phrase.StupidBackoff;
import io.skylite.core.search.suggest.term.TermSuggestion;
import io.skylite.core.search.suggest.term.TermSuggestionBuilder;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ParseFieldRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.common.geo.GeoShapeType;
import org.opensearch.common.geo.ShapesAvailability;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.DistanceFeatureQueryBuilder;
import org.opensearch.index.query.GeoBoundingBoxQueryBuilder;
import org.opensearch.index.query.GeoDistanceQueryBuilder;
import org.opensearch.index.query.GeoPolygonQueryBuilder;
import org.opensearch.index.query.GeoShapeQueryBuilder;
import org.opensearch.index.query.IntervalQueryBuilder;
import org.opensearch.index.query.IntervalsSourceProvider;
import org.opensearch.index.query.MoreLikeThisQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryParser;
import org.opensearch.index.query.ScriptQueryBuilder;
import org.opensearch.index.query.SpanMultiTermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.query.TermsSetQueryBuilder;
import org.opensearch.index.query.WrapperQueryBuilder;
import org.opensearch.index.query.functionscore.ExponentialDecayFunctionBuilder;
import org.opensearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.opensearch.index.query.functionscore.GaussDecayFunctionBuilder;
import org.opensearch.index.query.functionscore.LinearDecayFunctionBuilder;
import org.opensearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionParser;
import org.opensearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScriptScoreQueryBuilder;
import org.opensearch.search.aggregations.bucket.terms.heuristic.ChiSquare;
import org.opensearch.search.aggregations.bucket.terms.heuristic.GND;
import org.opensearch.search.aggregations.bucket.terms.heuristic.JLHScore;
import org.opensearch.search.aggregations.bucket.terms.heuristic.MutualInformation;
import org.opensearch.search.aggregations.bucket.terms.heuristic.PercentageScore;
import org.opensearch.search.aggregations.bucket.terms.heuristic.ScriptHeuristic;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.opensearch.search.aggregations.pipeline.EwmaModel;
import org.opensearch.search.aggregations.pipeline.HoltLinearModel;
import org.opensearch.search.aggregations.pipeline.HoltWintersModel;
import org.opensearch.search.aggregations.pipeline.LinearModel;
import org.opensearch.search.aggregations.pipeline.MovAvgModel;
import org.opensearch.search.aggregations.pipeline.SimpleModel;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.subphase.ExplainPhase;
import org.opensearch.search.fetch.subphase.FetchDocValuesPhase;
import org.opensearch.search.fetch.subphase.FetchFieldsPhase;
import org.opensearch.search.fetch.subphase.FetchScorePhase;
import org.opensearch.search.fetch.subphase.FetchSourcePhase;
import org.opensearch.search.fetch.subphase.FetchVersionPhase;
import org.opensearch.search.fetch.subphase.MatchedQueriesPhase;
import org.opensearch.search.fetch.subphase.ScriptFieldsPhase;
import org.opensearch.search.fetch.subphase.SeqNoPrimaryTermPhase;
import org.opensearch.search.fetch.subphase.highlight.FastVectorHighlighter;
import org.opensearch.search.fetch.subphase.highlight.HighlightPhase;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.opensearch.search.fetch.subphase.highlight.PlainHighlighter;
import org.opensearch.search.fetch.subphase.highlight.UnifiedHighlighter;

public class SearchModule {
    private static final List<ServiceLoader.Provider<AggregationProvider>> AGGREGATION_PROVIDERS = ServiceLoader.load(AggregationProvider.class, SearchModule.class.getClassLoader()).stream().collect(Collectors.toList());
    private static final List<ServiceLoader.Provider<SortBuilderProvider>> SORT_PARSER_PROVIDERS = ServiceLoader.load(SortBuilderProvider.class, SearchModule.class.getClassLoader()).stream().collect(Collectors.toList());
    private final Map<String, Highlighter> highlighters;
    private final ParseFieldRegistry<MovAvgModel.AbstractModelParser> movingAverageModelParserRegistry = new ParseFieldRegistry("moving_avg_model");
    private final List<FetchSubPhase> fetchSubPhases = new ArrayList<FetchSubPhase>();
    private final Settings settings;
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final List<NamedXContentRegistry.Entry> namedXContents = new ArrayList<NamedXContentRegistry.Entry>();
    private final AggregationRegistry aggregationRegistry;
    private final QueryPhaseSearcher queryPhaseSearcher;
    private final SearchPlugin.ExecutorServiceProvider indexSearcherExecutorProvider;

    public SearchModule(Settings settings, List<SearchPlugin> plugins) {
        this.settings = settings;
        this.registerSuggesters(plugins);
        this.highlighters = this.setupHighlighters(settings, plugins);
        this.registerScoreFunctions(plugins);
        this.registerQueryParsers(plugins);
        this.registerRescorers(plugins);
        this.registerSortParsers(plugins);
        this.registerValueFormats();
        this.registerSignificanceHeuristics(plugins);
        this.aggregationRegistry = this.registerAggregations(plugins);
        this.registerMovingAverageModels(plugins);
        this.registerPipelineAggregations(plugins);
        this.registerFetchSubPhases(plugins);
        this.registerSearchExts(plugins);
        this.registerShapes();
        this.registerIntervalsSourceProviders();
        this.queryPhaseSearcher = this.registerQueryPhaseSearcher(plugins);
        this.indexSearcherExecutorProvider = this.registerIndexSearcherExecutorProvider(plugins);
        this.namedWriteables.addAll(SortValue.namedWriteables());
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContents() {
        return this.namedXContents;
    }

    public AggregationRegistry getValuesSourceRegistry() {
        return this.aggregationRegistry;
    }

    public Map<String, Highlighter> getHighlighters() {
        return this.highlighters;
    }

    public ParseFieldRegistry<MovAvgModel.AbstractModelParser> getMovingAverageModelParserRegistry() {
        return this.movingAverageModelParserRegistry;
    }

    private Tuple<SearchPlugin.AggregationSpecInterface, Consumer<SearchPlugin.AggregationSpecInterface>> registerAggSpec(AggregationProvider provider, AggregationRegistry.Builder registryBuilder, List plugins) {
        AggregationProvider.Type type = provider.getType();
        switch (type) {
            case METRIC: 
            case BUCKET: {
                return new Tuple((Object)new SearchPlugin.AggregationSpec(provider.getName(), provider.getReader(), provider.getParser()), spec -> this.registerAggregation(((SearchPlugin.AggregationSpec)spec).setAggregatorRegistrar(provider.getAggregatorRegistrar(plugins)), registryBuilder));
            }
            case PIPELINE: {
                return new Tuple((Object)new SearchPlugin.PipelineAggregationSpec(provider.getName(), (Writeable.Reader<? extends PipelineAggregationBuilder>)provider.getReader(), (ContextParser<String, ? extends PipelineAggregationBuilder>)provider.getParser(provider.useOptionalParseFieldRegistry(Optional.of(this.movingAverageModelParserRegistry)))), spec -> this.registerPipelineAggregation((SearchPlugin.PipelineAggregationSpec)spec));
            }
        }
        throw new IllegalArgumentException("Unknown aggregation type found [" + String.valueOf(type) + "]");
    }

    private AggregationRegistry registerAggregations(List<SearchPlugin> plugins) {
        AggregationRegistry.Builder builder = new AggregationRegistry.Builder();
        AGGREGATION_PROVIDERS.stream().map(ServiceLoader.Provider::get).forEach(provider -> {
            Tuple<SearchPlugin.AggregationSpecInterface, Consumer<SearchPlugin.AggregationSpecInterface>> tuple = this.registerAggSpec((AggregationProvider)provider, builder, plugins);
            SearchPlugin.AggregationSpecInterface spec = (SearchPlugin.AggregationSpecInterface)tuple.v1();
            provider.getResultReaders().forEach(resultReader -> ((Optional)resultReader.v1()).ifPresentOrElse(name -> spec.addResultReader((String)name, (Writeable.Reader<? extends InternalAggregation>)((Writeable.Reader)resultReader.v2())), () -> spec.addResultReader((Writeable.Reader<? extends InternalAggregation>)((Writeable.Reader)resultReader.v2()))));
            ((Consumer)tuple.v2()).accept(spec);
        });
        this.registerFromPlugin(plugins, SearchPlugin::getAggregations, agg -> this.registerAggregation((SearchPlugin.AggregationSpec)agg, builder));
        this.registerFromPlugin(plugins, SearchPlugin::getAggregationExtentions, registrar -> {
            if (registrar != null) {
                registrar.accept(builder);
            }
        });
        return builder.build();
    }

    private void registerAggregation(SearchPlugin.AggregationSpec spec, AggregationRegistry.Builder builder) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> {
            String name = (String)c;
            return (BaseAggregationBuilder)((ContextParser)spec.getParser()).parse(p, (Object)name);
        }));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(AggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> t : spec.getResultReaders().entrySet()) {
            String writeableName = t.getKey();
            Writeable.Reader<? extends InternalAggregation> internalReader = t.getValue();
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, writeableName, internalReader));
        }
        Consumer<AggregationRegistry.Builder> register = spec.getAggregatorRegistrar();
        if (register != null) {
            register.accept(builder);
        } else {
            builder.registerUsage(spec.getName().getPreferredName());
        }
    }

    private void registerPipelineAggregations(List<SearchPlugin> plugins) {
        this.registerFromPlugin(plugins, SearchPlugin::getPipelineAggregations, this::registerPipelineAggregation);
    }

    private void registerPipelineAggregation(SearchPlugin.PipelineAggregationSpec spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> (BaseAggregationBuilder)((ContextParser)spec.getParser()).parse(p, (Object)((String)c))));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> resultReader : spec.getResultReaders().entrySet()) {
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, resultReader.getKey(), resultReader.getValue()));
        }
    }

    private void registerShapes() {
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.namedWriteables.addAll(GeoShapeType.getShapeWriteables());
        }
    }

    private void registerRescorers(List<SearchPlugin> plugins) {
        this.registerRescorer(new SearchPlugin.RescorerSpec("query", QueryRescorerBuilder::new, QueryRescorerBuilder::fromXContent));
        this.registerFromPlugin(plugins, SearchPlugin::getRescorers, this::registerRescorer);
    }

    private void registerRescorer(SearchPlugin.RescorerSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(RescorerBuilder.class, spec.getName(), (p, c) -> (RescorerBuilder)((CheckedFunction)spec.getParser()).apply((Object)p)));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(RescorerBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private <T> void registerFromPlugin(List<SearchPlugin> plugins, Function<SearchPlugin, List<T>> producer, Consumer<T> consumer) {
        for (SearchPlugin plugin : plugins) {
            for (T t : producer.apply(plugin)) {
                consumer.accept(t);
            }
        }
    }

    public static void registerSmoothingModels(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "laplace", Laplace::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "linear", LinearInterpolation::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "stupid_backoff", StupidBackoff::new));
    }

    private void registerSuggesters(List<SearchPlugin> plugins) {
        SearchModule.registerSmoothingModels(this.namedWriteables);
        this.registerSuggester(new SearchPlugin.SuggesterSpec("term", TermSuggestionBuilder::new, TermSuggestionBuilder::fromXContent, (Writeable.Reader<? extends Suggest.Suggestion>)((Writeable.Reader)TermSuggestion::new)));
        this.registerSuggester(new SearchPlugin.SuggesterSpec("phrase", PhraseSuggestionBuilder::new, PhraseSuggestionBuilder::fromXContent, (Writeable.Reader<? extends Suggest.Suggestion>)((Writeable.Reader)PhraseSuggestion::new)));
        this.registerSuggester(new SearchPlugin.SuggesterSpec("completion", CompletionSuggestionBuilder::new, CompletionSuggestionBuilder::fromXContent, (Writeable.Reader<? extends Suggest.Suggestion>)((Writeable.Reader)CompletionSuggestion::new)));
        this.registerFromPlugin(plugins, SearchPlugin::getSuggesters, this::registerSuggester);
    }

    private void registerSuggester(SearchPlugin.SuggesterSpec<?> suggester) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SuggestionBuilder.class, suggester.getName().getPreferredName(), suggester.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(SuggestionBuilder.class, suggester.getName(), (CheckedFunction)suggester.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(Suggest.Suggestion.class, suggester.getName().getPreferredName(), suggester.getSuggestionReader()));
    }

    private Map<String, Highlighter> setupHighlighters(Settings settings, List<SearchPlugin> plugins) {
        NamedRegistry highlighters = new NamedRegistry("highlighter");
        highlighters.register("fvh", (Object)new FastVectorHighlighter(settings));
        highlighters.register("plain", (Object)new PlainHighlighter());
        highlighters.register("unified", (Object)new UnifiedHighlighter());
        highlighters.extractAndRegister(plugins, SearchPlugin::getHighlighters);
        return Collections.unmodifiableMap(highlighters.getRegistry());
    }

    private void registerScoreFunctions(List<SearchPlugin> plugins) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScriptScoreFunctionBuilder.class, "script_score", ScriptScoreFunctionBuilder::new));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ScriptScoreFunctionBuilder>("script_score", ScriptScoreFunctionBuilder::new, ScriptScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<GaussDecayFunctionBuilder>("gauss", GaussDecayFunctionBuilder::new, GaussDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<LinearDecayFunctionBuilder>("linear", LinearDecayFunctionBuilder::new, LinearDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ExponentialDecayFunctionBuilder>("exp", ExponentialDecayFunctionBuilder::new, ExponentialDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<RandomScoreFunctionBuilder>("random_score", RandomScoreFunctionBuilder::new, RandomScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<FieldValueFactorFunctionBuilder>("field_value_factor", FieldValueFactorFunctionBuilder::new, FieldValueFactorFunctionBuilder::fromXContent));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, "weight", WeightBuilder::new));
        this.registerFromPlugin(plugins, SearchPlugin::getScoreFunctions, this::registerScoreFunction);
    }

    private void registerScoreFunction(SearchPlugin.ScoreFunctionSpec<?> scoreFunction) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName().getPreferredName(), scoreFunction.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName(), (p, c) -> ((ScoreFunctionParser)scoreFunction.getParser()).fromXContent(p)));
    }

    private void registerValueFormats() {
        this.registerValueFormat(DocValueFormat.BOOLEAN.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueFormat.BOOLEAN));
        this.registerValueFormat("date_time", (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)DocValueDateFormatters.DateTime::new));
        this.registerValueFormat("decimal", (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)DocValueFormat.Decimal::new));
        this.registerValueFormat(DocValueGeoFormatters.GEOHASH.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueGeoFormatters.GEOHASH));
        this.registerValueFormat(DocValueGeoFormatters.GEOTILE.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueGeoFormatters.GEOTILE));
        this.registerValueFormat(DocValueFormat.IP.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueFormat.IP));
        this.registerValueFormat(DocValueFormat.RAW.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueFormat.RAW));
        this.registerValueFormat(DocValueFormat.BINARY.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueFormat.BINARY));
        this.registerValueFormat(DocValueFormat.UNSIGNED_LONG_SHIFTED.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueFormat.UNSIGNED_LONG_SHIFTED));
        this.registerValueFormat(DocValueFormat.UNSIGNED_LONG.getWriteableName(), (Writeable.Reader<? extends DocValueFormat>)((Writeable.Reader)in -> DocValueFormat.UNSIGNED_LONG));
    }

    private void registerValueFormat(String name, Writeable.Reader<? extends DocValueFormat> reader) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(DocValueFormat.class, name, reader));
    }

    private void registerSignificanceHeuristics(List<SearchPlugin> plugins) {
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec("chi_square", ChiSquare::new, ChiSquare.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec("gnd", GND::new, GND.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec("jlh", JLHScore::new, JLHScore.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec("mutual_information", MutualInformation::new, MutualInformation.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec("percentage", PercentageScore::new, PercentageScore.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec("script_heuristic", ScriptHeuristic::new, ScriptHeuristic.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getSignificanceHeuristics, this::registerSignificanceHeuristic);
    }

    private <T extends SignificanceHeuristic> void registerSignificanceHeuristic(SearchPlugin.SignificanceHeuristicSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SignificanceHeuristic.class, spec.getName(), p -> (SignificanceHeuristic)((BiFunction)spec.getParser()).apply(p, null)));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SignificanceHeuristic.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerMovingAverageModels(List<SearchPlugin> plugins) {
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("simple", SimpleModel::new, SimpleModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("linear", LinearModel::new, LinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("ewma", EwmaModel::new, EwmaModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt", HoltLinearModel::new, HoltLinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt_winters", HoltWintersModel::new, HoltWintersModel.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getMovingAverageModels, this::registerMovingAverageModel);
    }

    private void registerMovingAverageModel(SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser> movAvgModel) {
        this.movingAverageModelParserRegistry.register((Object)movAvgModel.getParser(), movAvgModel.getName());
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(MovAvgModel.class, movAvgModel.getName().getPreferredName(), movAvgModel.getReader()));
    }

    private void registerFetchSubPhases(List<SearchPlugin> plugins) {
        this.registerFetchSubPhase(new ExplainPhase());
        this.registerFetchSubPhase(new FetchDocValuesPhase());
        this.registerFetchSubPhase(new ScriptFieldsPhase());
        this.registerFetchSubPhase(new FetchSourcePhase());
        this.registerFetchSubPhase(new FetchFieldsPhase());
        this.registerFetchSubPhase(new FetchVersionPhase());
        this.registerFetchSubPhase(new SeqNoPrimaryTermPhase());
        this.registerFetchSubPhase(new MatchedQueriesPhase());
        this.registerFetchSubPhase(new HighlightPhase(this.highlighters));
        this.registerFetchSubPhase(new FetchScorePhase());
        SearchPlugin.FetchPhaseConstructionContext context = new SearchPlugin.FetchPhaseConstructionContext(this.highlighters);
        this.registerFromPlugin(plugins, p -> p.getFetchSubPhases(context), this::registerFetchSubPhase);
    }

    private void registerSearchExts(List<SearchPlugin> plugins) {
        this.registerFromPlugin(plugins, SearchPlugin::getSearchExts, this::registerSearchExt);
    }

    private void registerSearchExt(SearchPlugin.SearchExtSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SearchExtBuilder.class, spec.getName(), (CheckedFunction)spec.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SearchExtBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerFetchSubPhase(FetchSubPhase subPhase) {
        Class<?> subPhaseClass = subPhase.getClass();
        if (this.fetchSubPhases.stream().anyMatch(p -> p.getClass().equals(subPhaseClass))) {
            throw new IllegalArgumentException("FetchSubPhase [" + String.valueOf(subPhaseClass) + "] already registered");
        }
        this.fetchSubPhases.add(Objects.requireNonNull(subPhase, "FetchSubPhase must not be null"));
    }

    private void registerQueryParsers(List<SearchPlugin> plugins) {
        this.registerQuery(new SearchPlugin.QuerySpec<MatchQueryBuilder>("match", MatchQueryBuilder::new, MatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhraseQueryBuilder>("match_phrase", MatchPhraseQueryBuilder::new, MatchPhraseQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhrasePrefixQueryBuilder>("match_phrase_prefix", MatchPhrasePrefixQueryBuilder::new, MatchPhrasePrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MultiMatchQueryBuilder>("multi_match", MultiMatchQueryBuilder::new, MultiMatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<NestedQueryBuilder>("nested", NestedQueryBuilder::new, NestedQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DisMaxQueryBuilder>("dis_max", DisMaxQueryBuilder::new, DisMaxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IdsQueryBuilder>("ids", IdsQueryBuilder::new, IdsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchAllQueryBuilder>("match_all", MatchAllQueryBuilder::new, MatchAllQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<QueryStringQueryBuilder>("query_string", QueryStringQueryBuilder::new, QueryStringQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<BoostingQueryBuilder>("boosting", BoostingQueryBuilder::new, BoostingQueryBuilder::fromXContent));
        IndexSearcher.setMaxClauseCount((int)((Integer)SearchServiceSettings.INDICES_MAX_CLAUSE_COUNT_SETTING.get(this.settings)));
        this.registerQuery(new SearchPlugin.QuerySpec<BoolQueryBuilder>("bool", BoolQueryBuilder::new, BoolQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermQueryBuilder>("term", TermQueryBuilder::new, TermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsQueryBuilder>("terms", TermsQueryBuilder::new, TermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FuzzyQueryBuilder>("fuzzy", FuzzyQueryBuilder::new, FuzzyQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RegexpQueryBuilder>("regexp", RegexpQueryBuilder::new, RegexpQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RangeQueryBuilder>("range", RangeQueryBuilder::new, RangeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<PrefixQueryBuilder>("prefix", PrefixQueryBuilder::new, PrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WildcardQueryBuilder>("wildcard", WildcardQueryBuilder::new, WildcardQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ConstantScoreQueryBuilder>("constant_score", ConstantScoreQueryBuilder::new, ConstantScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanTermQueryBuilder>("span_term", SpanTermQueryBuilder::new, SpanTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNotQueryBuilder>("span_not", SpanNotQueryBuilder::new, SpanNotQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanWithinQueryBuilder>("span_within", SpanWithinQueryBuilder::new, SpanWithinQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanContainingQueryBuilder>("span_containing", SpanContainingQueryBuilder::new, SpanContainingQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FieldMaskingSpanQueryBuilder>(FieldMaskingSpanQueryBuilder.SPAN_FIELD_MASKING_FIELD, FieldMaskingSpanQueryBuilder::new, FieldMaskingSpanQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanFirstQueryBuilder>("span_first", SpanFirstQueryBuilder::new, SpanFirstQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder>("span_near", SpanNearQueryBuilder::new, SpanNearQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder.SpanGapQueryBuilder>("span_gap", SpanNearQueryBuilder.SpanGapQueryBuilder::new, SpanNearQueryBuilder.SpanGapQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanOrQueryBuilder>("span_or", SpanOrQueryBuilder::new, SpanOrQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MoreLikeThisQueryBuilder>("more_like_this", MoreLikeThisQueryBuilder::new, MoreLikeThisQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WrapperQueryBuilder>("wrapper", WrapperQueryBuilder::new, WrapperQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanMultiTermQueryBuilder>("span_multi", SpanMultiTermQueryBuilder::new, SpanMultiTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FunctionScoreQueryBuilder>("function_score", FunctionScoreQueryBuilder::new, FunctionScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptScoreQueryBuilder>("script_score", ScriptScoreQueryBuilder::new, ScriptScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SimpleQueryStringBuilder>("simple_query_string", SimpleQueryStringBuilder::new, SimpleQueryStringBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptQueryBuilder>("script", ScriptQueryBuilder::new, ScriptQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoDistanceQueryBuilder>("geo_distance", GeoDistanceQueryBuilder::new, GeoDistanceQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoBoundingBoxQueryBuilder>("geo_bounding_box", GeoBoundingBoxQueryBuilder::new, GeoBoundingBoxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoPolygonQueryBuilder>("geo_polygon", GeoPolygonQueryBuilder::new, GeoPolygonQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ExistsQueryBuilder>("exists", ExistsQueryBuilder::new, ExistsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchNoneQueryBuilder>("match_none", MatchNoneQueryBuilder::new, MatchNoneQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsSetQueryBuilder>("terms_set", TermsSetQueryBuilder::new, TermsSetQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IntervalQueryBuilder>("intervals", IntervalQueryBuilder::new, IntervalQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DistanceFeatureQueryBuilder>("distance_feature", DistanceFeatureQueryBuilder::new, DistanceFeatureQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchBoolPrefixQueryBuilder>("match_bool_prefix", MatchBoolPrefixQueryBuilder::new, MatchBoolPrefixQueryBuilder::fromXContent));
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.registerQuery(new SearchPlugin.QuerySpec<GeoShapeQueryBuilder>("geo_shape", GeoShapeQueryBuilder::new, GeoShapeQueryBuilder::fromXContent));
        }
        this.registerFromPlugin(plugins, SearchPlugin::getQueries, this::registerQuery);
    }

    private void registerSortParsers(List<SearchPlugin> plugins) {
        SORT_PARSER_PROVIDERS.stream().map(ServiceLoader.Provider::get).forEach(provider -> {
            SearchPlugin.SortSpec spec = provider.getNameWithAlternatives() == null ? new SearchPlugin.SortSpec(provider.getName(), provider.getBuilder(), provider.getParser()) : new SearchPlugin.SortSpec(provider.getNameWithAlternatives(), provider.getBuilder(), provider.getParser());
            this.registerSort(spec);
        });
        this.registerFromPlugin(plugins, SearchPlugin::getSorts, this::registerSort);
    }

    private void registerIntervalsSourceProviders() {
        this.namedWriteables.addAll(SearchModule.getIntervalsSourceProviderNamedWritables());
    }

    public static List<NamedWriteableRegistry.Entry> getIntervalsSourceProviderNamedWritables() {
        return Collections.unmodifiableList(Arrays.asList(new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "match", IntervalsSourceProvider.Match::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "all_of", IntervalsSourceProvider.Combine::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "any_of", IntervalsSourceProvider.Disjunction::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "prefix", IntervalsSourceProvider.Prefix::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "wildcard", IntervalsSourceProvider.Wildcard::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "regexp", IntervalsSourceProvider.Regexp::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "fuzzy", IntervalsSourceProvider.Fuzzy::new)));
    }

    private void registerQuery(SearchPlugin.QuerySpec<?> spec) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(QueryBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(QueryBuilder.class, spec.getName(), (p, c) -> ((QueryParser)spec.getParser()).fromXContent(p)));
    }

    private void registerSort(SearchPlugin.SortSpec<?> spec) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(BaseSortBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(BaseSortBuilder.class, spec.getName(), (p, c) -> (BaseSortBuilder)((ContextParser)spec.getParser()).parse(p, (Object)spec.getName().getPreferredName())));
    }

    private QueryPhaseSearcher registerQueryPhaseSearcher(List<SearchPlugin> plugins) {
        QueryPhaseSearcherWrapper searcher = null;
        for (SearchPlugin plugin : plugins) {
            Optional<QueryPhaseSearcher> searcherOpt = plugin.getQueryPhaseSearcher();
            if (searcher == null) {
                searcher = searcherOpt.orElse(null);
                continue;
            }
            if (!searcherOpt.isPresent()) continue;
            throw new IllegalStateException("Only one QueryPhaseSearcher is allowed, but more than one are provided by the plugins");
        }
        if (searcher == null) {
            searcher = new QueryPhaseSearcherWrapper();
        }
        return searcher;
    }

    private SearchPlugin.ExecutorServiceProvider registerIndexSearcherExecutorProvider(List<SearchPlugin> plugins) {
        SearchPlugin.ExecutorServiceProvider provider = null;
        for (SearchPlugin plugin : plugins) {
            Optional<SearchPlugin.ExecutorServiceProvider> providerOpt = plugin.getIndexSearcherExecutorProvider();
            if (provider == null) {
                provider = providerOpt.orElse(null);
                continue;
            }
            if (!providerOpt.isPresent()) continue;
            throw new IllegalStateException("The index searcher executor is already assigned but more than one are provided by the plugins");
        }
        if (provider == null && FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled")) {
            provider = threadPool -> threadPool.executor("index_searcher");
        }
        return provider;
    }

    public FetchPhase getFetchPhase() {
        return new FetchPhase(this.fetchSubPhases);
    }

    public QueryPhase getQueryPhase() {
        return new QueryPhase(this.queryPhaseSearcher);
    }

    @Nullable
    public ExecutorService getIndexSearcherExecutor(ThreadPool pool) {
        return this.indexSearcherExecutorProvider != null ? this.indexSearcherExecutorProvider.getExecutor(pool) : null;
    }
}

