/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchException;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentLocation;
import java.io.IOException;

public class SearchParseException
extends SearchException {
    public static final int UNKNOWN_POSITION = -1;
    private final int lineNumber;
    private final int columnNumber;

    public SearchParseException(SearchShardTarget shardTarget, String msg, @Nullable XContentLocation location) {
        this(shardTarget, msg, location, null);
    }

    public SearchParseException(SearchShardTarget shardTarget, String msg, @Nullable XContentLocation location, Throwable cause) {
        super(shardTarget, msg, cause);
        int lineNumber = -1;
        int columnNumber = -1;
        if (location != null && location != null) {
            lineNumber = location.lineNumber;
            columnNumber = location.columnNumber;
        }
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    public SearchParseException(StreamInput in) throws IOException {
        super(in);
        this.lineNumber = in.readInt();
        this.columnNumber = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.lineNumber);
        out.writeInt(this.columnNumber);
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.lineNumber != -1) {
            builder.field("line", this.lineNumber);
            builder.field("col", this.columnNumber);
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public static class Registration
    implements SkyliteExceptionProvider<SearchParseException> {
        public Class<SearchParseException> getExceptionClass() {
            return SearchParseException.class;
        }

        public CheckedFunction<StreamInput, SearchParseException, IOException> getConstructor() {
            return SearchParseException::new;
        }

        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        public int getLegacyId() {
            return 72;
        }
    }
}

