/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import io.skylite.SkyliteException;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.search.DeletePitInfo;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.ListPitInfo;
import io.skylite.core.action.search.PitSearchContextIdForNode;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.action.search.SearchType;
import io.skylite.core.action.search.UpdatePitContextRequest;
import io.skylite.core.action.search.UpdatePitContextResponse;
import io.skylite.core.action.search.query.QuerySearchRequest;
import io.skylite.core.action.search.query.ScrollQuerySearchResult;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationInitializationException;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.MultiBucketConsumerService;
import io.skylite.core.aggregations.SearchContextAggregations;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.query.MatchNoneQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.SearchOperationListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.cluster.AllocatedIndicesInterface;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.script.FieldScript;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.BaseSearchService;
import io.skylite.core.search.RescoreDocIds;
import io.skylite.core.search.Scroll;
import io.skylite.core.search.SearchContextMissingException;
import io.skylite.core.search.SearchException;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.collapse.CollapseContext;
import io.skylite.core.search.dfs.DfsSearchResult;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.fetch.QueryFetchSearchResult;
import io.skylite.core.search.fetch.ScrollQueryFetchSearchResult;
import io.skylite.core.search.fetch.ShardFetchRequest;
import io.skylite.core.search.fetch.subphase.FetchDocValuesContext;
import io.skylite.core.search.fetch.subphase.FetchFieldsContext;
import io.skylite.core.search.fetch.subphase.ScriptFieldsContext;
import io.skylite.core.search.fetch.subphase.highlight.HighlightBuilder;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.internal.ContextIndexSearcher;
import io.skylite.core.search.internal.InternalScrollSearchRequest;
import io.skylite.core.search.internal.ProfilableIndexSearcher;
import io.skylite.core.search.internal.ReaderContext;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.profile.Profilers;
import io.skylite.core.search.query.QueryPhase;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.rescore.RescorerBuilder;
import io.skylite.core.search.searchafter.SearchAfterBuilder;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.search.sort.MinAndMax;
import io.skylite.core.search.sort.SortAndFormats;
import io.skylite.core.search.sort.SortBuilder;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.search.suggest.completion.CompletionSuggestion;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.index.IndexService;
import org.opensearch.index.query.InnerHitContextBuilder;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.search.DefaultSearchContext;
import org.opensearch.search.aggregations.support.ProductionAggregationContext;
import org.opensearch.search.dfs.DfsPhase;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.internal.LegacyReaderContext;
import org.opensearch.search.internal.PitReaderContext;
import org.opensearch.search.internal.SearchContext;

public class SearchService
extends BaseSearchService
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SearchService.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final BigArrays bigArrays;
    private final DfsPhase dfsPhase = new DfsPhase();
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private volatile long defaultKeepAlive;
    private volatile long maxKeepAlive;
    private volatile long maxPitKeepAlive;
    private volatile TimeValue defaultSearchTimeout;
    private volatile boolean lowLevelCancellation;
    private volatile int maxOpenScrollContext;
    private volatile int maxOpenPitContext;
    private final Scheduler.Cancellable keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final MultiBucketConsumerService multiBucketConsumerService;
    private final AtomicInteger openScrollContexts = new AtomicInteger();
    private final AtomicInteger openPitContexts = new AtomicInteger();
    private final Executor indexSearcherExecutor;

    public SearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, QueryPhase queryPhase, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, Executor indexSearcherExecutor) {
        super(responseCollectorService);
        Settings settings = clusterService.getSettings();
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.bigArrays = bigArrays;
        this.queryPhase = queryPhase;
        this.fetchPhase = fetchPhase;
        this.multiBucketConsumerService = new MultiBucketConsumerService(clusterService, settings, circuitBreakerService.getBreaker("request"));
        this.indexSearcherExecutor = indexSearcherExecutor;
        TimeValue keepAliveInterval = (TimeValue)SearchServiceSettings.KEEPALIVE_INTERVAL_SETTING.get(settings);
        this.setKeepAlives((TimeValue)SearchServiceSettings.DEFAULT_KEEPALIVE_SETTING.get(settings), (TimeValue)SearchServiceSettings.MAX_KEEPALIVE_SETTING.get(settings));
        this.setPitKeepAlives((TimeValue)SearchServiceSettings.DEFAULT_KEEPALIVE_SETTING.get(settings), (TimeValue)SearchServiceSettings.MAX_PIT_KEEPALIVE_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.DEFAULT_KEEPALIVE_SETTING, SearchServiceSettings.MAX_PIT_KEEPALIVE_SETTING, this::setPitKeepAlives, this::validatePitKeepAlives);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.DEFAULT_KEEPALIVE_SETTING, SearchServiceSettings.MAX_KEEPALIVE_SETTING, this::setKeepAlives, this::validateKeepAlives);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay((Runnable)new Reaper(), keepAliveInterval, "same");
        this.defaultSearchTimeout = (TimeValue)SearchServiceSettings.DEFAULT_SEARCH_TIMEOUT_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.DEFAULT_SEARCH_TIMEOUT_SETTING, this::setDefaultSearchTimeout);
        this.defaultAllowPartialSearchResults = (Boolean)SearchServiceSettings.DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS, x$0 -> this.setDefaultAllowPartialSearchResults((boolean)x$0));
        this.maxOpenScrollContext = (Integer)SearchServiceSettings.MAX_OPEN_SCROLL_CONTEXT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.MAX_OPEN_SCROLL_CONTEXT, this::setMaxOpenScrollContext);
        this.maxOpenPitContext = (Integer)SearchServiceSettings.MAX_OPEN_PIT_CONTEXT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.MAX_OPEN_PIT_CONTEXT, this::setMaxOpenPitContext);
        this.lowLevelCancellation = (Boolean)SearchServiceSettings.LOW_LEVEL_CANCELLATION_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.LOW_LEVEL_CANCELLATION_SETTING, this::setLowLevelCancellation);
    }

    private void validateKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        if (defaultKeepAlive.millis() > maxKeepAlive.millis()) {
            throw new IllegalArgumentException("Default keep alive setting for request [" + SearchServiceSettings.DEFAULT_KEEPALIVE_SETTING.getKey() + "] should be smaller than max keep alive [" + SearchServiceSettings.MAX_KEEPALIVE_SETTING.getKey() + "], was (" + String.valueOf(defaultKeepAlive) + " > " + String.valueOf(maxKeepAlive) + ")");
        }
    }

    private void validatePitKeepAlives(TimeValue defaultKeepAlive, TimeValue maxPitKeepAlive) {
        if (defaultKeepAlive.millis() > maxPitKeepAlive.millis()) {
            throw new IllegalArgumentException("Default keep alive setting for request [" + SearchServiceSettings.DEFAULT_KEEPALIVE_SETTING.getKey() + "] should be smaller than max keep alive for PIT [" + SearchServiceSettings.MAX_PIT_KEEPALIVE_SETTING.getKey() + "], was (" + String.valueOf(defaultKeepAlive) + " > " + String.valueOf(maxPitKeepAlive) + ")");
        }
    }

    private void setKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        this.validateKeepAlives(defaultKeepAlive, maxKeepAlive);
        this.defaultKeepAlive = defaultKeepAlive.millis();
        this.maxKeepAlive = maxKeepAlive.millis();
    }

    private void setPitKeepAlives(TimeValue defaultKeepAlive, TimeValue maxPitKeepAlive) {
        this.validatePitKeepAlives(defaultKeepAlive, maxPitKeepAlive);
        this.maxPitKeepAlive = maxPitKeepAlive.millis();
    }

    private void setDefaultSearchTimeout(TimeValue defaultSearchTimeout) {
        this.defaultSearchTimeout = defaultSearchTimeout;
    }

    private void setMaxOpenScrollContext(int maxOpenScrollContext) {
        this.maxOpenScrollContext = maxOpenScrollContext;
    }

    private void setMaxOpenPitContext(int maxOpenPitContext) {
        this.maxOpenPitContext = maxOpenPitContext;
    }

    private void setLowLevelCancellation(Boolean lowLevelCancellation) {
        this.lowLevelCancellation = lowLevelCancellation;
    }

    public void afterIndexRemoved(Index index, IndexSettings indexSettings, AllocatedIndicesInterface.IndexRemovalReason reason) {
        if (reason == AllocatedIndicesInterface.IndexRemovalReason.DELETED || reason == AllocatedIndicesInterface.IndexRemovalReason.CLOSED || reason == AllocatedIndicesInterface.IndexRemovalReason.REOPENED) {
            this.freeAllContextForIndex(index);
        }
    }

    protected void putReaderContext(ReaderContext context) {
        ReaderContext previous = (ReaderContext)this.activeReaders.put(context.id().getId(), (Object)context);
        assert (previous == null);
        Index index = context.indexShard().shardId().getIndex();
        if (!this.indicesService.hasIndex(index)) {
            this.removeReaderContext(context.id().getId());
            throw new IndexNotFoundException(index);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
        for (ReaderContext context : this.activeReaders.values()) {
            this.freeReaderContext(context.id());
        }
    }

    protected void doClose() {
        this.doStop();
        this.keepAliveReaper.cancel();
    }

    public void executeDfsPhase(final ShardSearchRequest request, final boolean keepStatesInContext, final SearchShardTask task, final ActionListener<SearchPhaseResult> listener) {
        BaseIndexShard baseShard = this.getShard(request);
        final IndexShard shard = (IndexShard)baseShard;
        this.rewriteAndFetchShardRequest(shard, request, new ActionListener<ShardSearchRequest>(){

            public void onResponse(ShardSearchRequest rewritten) {
                SearchService.this.runAsync(SearchService.this.getExecutor(shard), () -> SearchService.this.executeDfsPhase(request, task, keepStatesInContext), listener);
            }

            public void onFailure(Exception exc) {
                listener.onFailure(exc);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected DfsSearchResult executeDfsPhase(ShardSearchRequest request, SearchShardTask task, boolean keepStatesInContext) throws IOException {
        ReaderContext readerContext = this.createOrGetReaderContext(request, keepStatesInContext);
        try (Releasable ignored = readerContext.markAsUsed(this.getKeepAlive(request));){
            DfsSearchResult dfsSearchResult;
            block14: {
                SearchContext context = this.createContext(readerContext, request, task, true);
                try {
                    this.dfsPhase.execute(context);
                    dfsSearchResult = context.dfsResult();
                    if (context == null) break block14;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                context.close();
            }
            return dfsSearchResult;
        }
        catch (Exception e) {
            logger.trace("Dfs phase failed", (Throwable)e);
            this.processFailure(readerContext, e);
            throw e;
        }
    }

    private void loadOrExecuteQueryPhase(ShardSearchRequest request, SearchContext context) throws Exception {
        boolean canCache = this.indicesService.canCache(request, context);
        context.getQueryShardContext().freezeContext();
        if (canCache) {
            this.indicesService.loadIntoContext(request, context, this.queryPhase);
        } else {
            this.queryPhase.execute((SearchExecutionContext)context);
        }
    }

    public void executeQueryPhase(ShardSearchRequest request, final boolean keepStatesInContext, final SearchShardTask task, final ActionListener<SearchPhaseResult> listener) {
        assert (!request.canReturnNullResponseIfMatchNoDocs() || request.numberOfShards() > 1) : "empty responses require more than one shard";
        final BaseIndexShard shard = this.getShard(request);
        this.rewriteAndFetchShardRequest(shard, request, new ActionListener<ShardSearchRequest>(){

            public void onResponse(ShardSearchRequest orig) {
                if (orig.canReturnNullResponseIfMatchNoDocs()) {
                    SearchPhaseResult.CanMatchResponse canMatchResp;
                    assert (orig.scroll() == null);
                    try {
                        ShardSearchRequest clone = new ShardSearchRequest(orig);
                        canMatchResp = SearchService.this.canMatch(clone, false);
                    }
                    catch (Exception exc) {
                        listener.onFailure(exc);
                        return;
                    }
                    if (!canMatchResp.canMatch()) {
                        listener.onResponse((Object)QuerySearchResult.nullInstance());
                        return;
                    }
                }
                SearchService.this.runAsync(SearchService.this.getExecutor(shard), () -> SearchService.this.executeQueryPhase(orig, task, keepStatesInContext), listener);
            }

            public void onFailure(Exception exc) {
                listener.onFailure(exc);
            }
        });
    }

    private BaseIndexShard getShard(ShardSearchRequest request) {
        if (request.readerId() != null) {
            return this.findReaderContext(request.readerId(), (TransportRequest)request).indexShard();
        }
        return this.indicesService.indexServiceSafe(request.shardId().getIndex()).getShard(request.shardId().id());
    }

    private <T> void runAsync(Executor executor, CheckedSupplier<T, Exception> executable, ActionListener<T> listener) {
        executor.execute((Runnable)ActionRunnable.supply(listener, () -> executable.get()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected SearchPhaseResult executeQueryPhase(ShardSearchRequest request, SearchShardTask task, boolean keepStatesInContext) throws Exception {
        ReaderContext readerContext = this.createOrGetReaderContext(request, keepStatesInContext);
        try (Releasable ignored = readerContext.markAsUsed(this.getKeepAlive(request));){
            QuerySearchResult querySearchResult;
            block26: {
                SearchContext context;
                block24: {
                    SearchOperationListenerExecutor executor;
                    block25: {
                        context = this.createContext(readerContext, request, task, true);
                        try {
                            long afterQueryTime;
                            executor = new SearchOperationListenerExecutor(context);
                            try {
                                this.loadOrExecuteQueryPhase(request, context);
                                if (!context.queryResult().hasSearchContext() && readerContext.singleSession()) {
                                    this.freeReaderContext(readerContext.id());
                                }
                                afterQueryTime = executor.success();
                            }
                            finally {
                                executor.close();
                            }
                            if (request.numberOfShards() != 1) break block24;
                            executor = this.executeFetchPhase(readerContext, context, afterQueryTime);
                            if (context == null) break block25;
                        }
                        catch (Throwable throwable) {
                            if (context != null) {
                                try {
                                    context.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        context.close();
                    }
                    return executor;
                }
                RescoreDocIds rescoreDocIds = context.rescoreDocIds();
                context.queryResult().setRescoreDocIds(rescoreDocIds);
                readerContext.setRescoreDocIds(rescoreDocIds);
                querySearchResult = context.queryResult();
                if (context == null) break block26;
                context.close();
            }
            return querySearchResult;
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                e = e.getCause() == null || e.getCause() instanceof Exception ? (Exception)e.getCause() : new SkyliteException(e.getCause());
            }
            logger.trace("Query phase failed", (Throwable)e);
            this.processFailure(readerContext, e);
            throw e;
        }
    }

    private QueryFetchSearchResult executeFetchPhase(ReaderContext reader, SearchContext context, long afterQueryTime) {
        try (SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(context, true, afterQueryTime);){
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (reader.singleSession()) {
                this.freeReaderContext(reader.id());
            }
            executor.success();
        }
        return new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
    }

    public void executeQueryPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQuerySearchResult> listener) {
        Releasable markAsUsed;
        LegacyReaderContext readerContext = (LegacyReaderContext)this.findReaderContext(request.contextId(), (TransportRequest)request);
        try {
            markAsUsed = readerContext.markAsUsed(this.getScrollKeepAlive(request.scroll()));
        }
        catch (Exception e) {
            this.freeReaderContext(readerContext.id());
            throw e;
        }
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(null);
            try (SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, false);){
                SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(searchContext);
                try {
                    searchContext.searcher().setAggregatedDfs(readerContext.getAggregatedDfs(null));
                    this.processScroll(request, readerContext, searchContext);
                    this.queryPhase.execute((SearchExecutionContext)searchContext);
                    executor.success();
                    readerContext.setRescoreDocIds(searchContext.rescoreDocIds());
                    ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(searchContext.queryResult(), searchContext.shardTarget());
                    executor.close();
                    return scrollQuerySearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        executor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.trace("Query phase failed", (Throwable)e);
                throw e;
            }
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    public void executeQueryPhase(QuerySearchRequest request, SearchShardTask task, ActionListener<QuerySearchResult> listener) {
        ReaderContext readerContext = this.findReaderContext(request.contextId(), (TransportRequest)request.shardSearchRequest());
        ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(request.shardSearchRequest());
        Releasable markAsUsed = readerContext.markAsUsed(this.getKeepAlive(shardSearchRequest));
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            readerContext.setAggregatedDfs(request.dfs());
            try (SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, true);){
                SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(searchContext);
                try {
                    searchContext.searcher().setAggregatedDfs(request.dfs());
                    this.queryPhase.execute((SearchExecutionContext)searchContext);
                    if (!searchContext.queryResult().hasSearchContext() && readerContext.singleSession()) {
                        this.freeReaderContext(readerContext.id());
                    }
                    executor.success();
                    RescoreDocIds rescoreDocIds = searchContext.rescoreDocIds();
                    searchContext.queryResult().setRescoreDocIds(rescoreDocIds);
                    readerContext.setRescoreDocIds(rescoreDocIds);
                    QuerySearchResult querySearchResult = searchContext.queryResult();
                    executor.close();
                    return querySearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        executor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                assert (!TransportActions.isShardNotAvailableException((Throwable)e)) : new AssertionError((Object)e);
                logger.trace("Query phase failed", (Throwable)e);
                throw e;
            }
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    private Executor getExecutor(BaseIndexShard indexShard) {
        assert (indexShard != null);
        String executorName = indexShard.isSystem() ? "system_read" : (indexShard.indexSettings().isSearchThrottled() ? "search_throttled" : "search");
        return this.threadPool.executor(executorName);
    }

    public void executeFetchPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQueryFetchSearchResult> listener) {
        Releasable markAsUsed;
        LegacyReaderContext readerContext = (LegacyReaderContext)this.findReaderContext(request.contextId(), (TransportRequest)request);
        try {
            markAsUsed = readerContext.markAsUsed(this.getScrollKeepAlive(request.scroll()));
        }
        catch (Exception e) {
            this.freeReaderContext(readerContext.id());
            throw e;
        }
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(null);
            try (SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, false);){
                SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(searchContext);
                try {
                    searchContext.assignRescoreDocIds(readerContext.getRescoreDocIds(null));
                    searchContext.searcher().setAggregatedDfs(readerContext.getAggregatedDfs(null));
                    this.processScroll(request, readerContext, searchContext);
                    this.queryPhase.execute((SearchExecutionContext)searchContext);
                    long afterQueryTime = executor.success();
                    QueryFetchSearchResult fetchSearchResult = this.executeFetchPhase(readerContext, searchContext, afterQueryTime);
                    ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(fetchSearchResult, searchContext.shardTarget());
                    executor.close();
                    return scrollQueryFetchSearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        executor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                assert (!TransportActions.isShardNotAvailableException((Throwable)e)) : new AssertionError((Object)e);
                logger.trace("Fetch phase failed", (Throwable)e);
                throw e;
            }
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    public void executeFetchPhase(ShardFetchRequest request, SearchShardTask task, ActionListener<FetchSearchResult> listener) {
        ReaderContext readerContext = this.findReaderContext(request.contextId(), (TransportRequest)request);
        ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(request.getShardSearchRequest());
        Releasable markAsUsed = readerContext.markAsUsed(this.getKeepAlive(shardSearchRequest));
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            FetchSearchResult fetchSearchResult;
            block17: {
                SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, false);
                try {
                    if (request.lastEmittedDoc() != null) {
                        searchContext.scrollContext().lastEmittedDoc = request.lastEmittedDoc();
                    }
                    searchContext.assignRescoreDocIds(readerContext.getRescoreDocIds(request.getRescoreDocIds()));
                    searchContext.searcher().setAggregatedDfs(readerContext.getAggregatedDfs(request.getAggregatedDfs()));
                    searchContext.docIdsToLoad(request.docIds(), request.docIdsSize());
                    try (SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(searchContext, true, System.nanoTime());){
                        this.fetchPhase.execute(searchContext);
                        if (readerContext.singleSession()) {
                            this.freeReaderContext(request.contextId());
                        }
                        executor.success();
                    }
                    fetchSearchResult = searchContext.fetchResult();
                    if (searchContext == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (searchContext != null) {
                            try {
                                searchContext.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        assert (!TransportActions.isShardNotAvailableException((Throwable)e)) : new AssertionError((Object)e);
                        throw e;
                    }
                }
                searchContext.close();
            }
            return fetchSearchResult;
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    private ReaderContext findReaderContext(ShardSearchContextId id, TransportRequest request) throws SearchContextMissingException {
        ReaderContext reader = this.getReaderContext(id);
        if (reader == null) {
            throw new SearchContextMissingException(id);
        }
        try {
            reader.validate(request);
        }
        catch (Exception exc) {
            this.processFailure(reader, exc);
            throw exc;
        }
        return reader;
    }

    final ReaderContext createOrGetReaderContext(ShardSearchRequest request, boolean keepStatesInContext) {
        IndexShard baseShard;
        if (request.readerId() != null) {
            assert (!keepStatesInContext);
            return this.findReaderContext(request.readerId(), (TransportRequest)request);
        }
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = baseShard = indexService.getShard(request.shardId().id());
        Engine.SearcherSupplier reader = shard.acquireSearcherSupplier();
        return this.createAndPutReaderContext(request, indexService, shard, reader, keepStatesInContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ReaderContext createAndPutReaderContext(ShardSearchRequest request, IndexService indexService, IndexShard shard, Engine.SearcherSupplier reader, boolean keepStatesInContext) {
        LegacyReaderContext legacyReaderContext;
        assert (request.readerId() == null);
        assert (request.keepAlive() == null);
        LegacyReaderContext readerContext = null;
        Releasable decreaseScrollContexts = null;
        try {
            if (request.scroll() != null) {
                decreaseScrollContexts = this.openScrollContexts::decrementAndGet;
                if (this.openScrollContexts.incrementAndGet() > this.maxOpenScrollContext) {
                    throw new SkyliteRejectedExecutionException("Trying to create too many scroll contexts. Must be less than or equal to: [" + this.maxOpenScrollContext + "]. This limit can be set by changing the [" + SearchServiceSettings.MAX_OPEN_SCROLL_CONTEXT.getKey() + "] setting.");
                }
            }
            long keepAlive = this.getKeepAlive(request);
            ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
            if (keepStatesInContext || request.scroll() != null) {
                readerContext = new LegacyReaderContext(id, indexService, shard, reader, request, keepAlive);
                if (request.scroll() != null) {
                    readerContext.addOnClose(decreaseScrollContexts);
                    decreaseScrollContexts = null;
                }
            } else {
                readerContext = new ReaderContext(id, (BaseIndexService)indexService, (BaseIndexShard)shard, reader, keepAlive, request.keepAlive() == null);
            }
            reader = null;
            LegacyReaderContext finalReaderContext = readerContext;
            SearchOperationListener searchOperationListener = shard.getSearchOperationListener();
            searchOperationListener.onNewReaderContext((ReaderContext)finalReaderContext);
            if (finalReaderContext.scrollContext() != null) {
                searchOperationListener.onNewScrollContext((ReaderContext)finalReaderContext);
            }
            readerContext.addOnClose(() -> {
                try {
                    if (finalReaderContext.scrollContext() != null) {
                        searchOperationListener.onFreeScrollContext(finalReaderContext);
                    }
                }
                finally {
                    searchOperationListener.onFreeReaderContext(finalReaderContext);
                }
            });
            this.putReaderContext(finalReaderContext);
            readerContext = null;
            legacyReaderContext = finalReaderContext;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{reader, readerContext, decreaseScrollContexts});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{reader, readerContext, decreaseScrollContexts});
        return legacyReaderContext;
    }

    public void createPitReaderContext(ShardId shardId, TimeValue keepAlive, ActionListener<ShardSearchContextId> listener) {
        IndexShard baseShard;
        this.checkPitKeepAliveLimit(keepAlive.millis());
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard shard = baseShard = indexService.getShard(shardId.id());
        SearchOperationListener searchOperationListener = shard.getSearchOperationListener();
        shard.awaitShardSearchActive(ignored -> {
            Engine.SearcherSupplier searcherSupplier = null;
            PitReaderContext readerContext = null;
            Releasable decreasePitContexts = this.openPitContexts::decrementAndGet;
            try {
                if (this.openPitContexts.incrementAndGet() > this.maxOpenPitContext) {
                    throw new SkyliteRejectedExecutionException("Trying to create too many Point In Time contexts. Must be less than or equal to: [" + this.maxOpenPitContext + "]. This limit can be set by changing the [" + SearchServiceSettings.MAX_OPEN_PIT_CONTEXT.getKey() + "] setting.");
                }
                searcherSupplier = shard.acquireSearcherSupplier();
                ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
                PitReaderContext finalReaderContext = readerContext = new PitReaderContext(id, indexService, shard, searcherSupplier, keepAlive.millis(), false);
                searcherSupplier = null;
                searchOperationListener.onNewReaderContext((ReaderContext)readerContext);
                searchOperationListener.onNewPitContext((ReaderContext)finalReaderContext);
                readerContext.addOnClose(() -> {
                    searchOperationListener.onFreeReaderContext(finalReaderContext);
                    searchOperationListener.onFreePitContext(finalReaderContext);
                });
                readerContext.addOnClose(decreasePitContexts);
                this.putReaderContext(readerContext);
                readerContext = null;
                listener.onResponse((Object)finalReaderContext.id());
            }
            catch (Exception exc) {
                Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{decreasePitContexts});
                Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{searcherSupplier, readerContext});
                listener.onFailure(exc);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePitIdAndKeepAlive(UpdatePitContextRequest request, ActionListener<UpdatePitContextResponse> listener) {
        this.checkPitKeepAliveLimit(request.getKeepAlive());
        PitReaderContext readerContext = this.getPitReaderContext(request.getSearchContextId());
        if (readerContext == null) {
            throw new SearchContextMissingException(request.getSearchContextId());
        }
        try (Releasable updatePit = null;){
            updatePit = readerContext.updatePitIdAndKeepAlive(request.getKeepAlive(), request.getPitId(), request.getCreationTime());
            listener.onResponse((Object)new UpdatePitContextResponse(request.getPitId(), request.getCreationTime(), request.getKeepAlive()));
        }
    }

    public PitReaderContext getPitReaderContext(ShardSearchContextId id) {
        ReaderContext context = (ReaderContext)this.activeReaders.get(id.getId());
        if (context instanceof PitReaderContext) {
            return (PitReaderContext)context;
        }
        return null;
    }

    public List<ListPitInfo> getAllPITReaderContexts() {
        ArrayList<ListPitInfo> pitContextsInfo = new ArrayList<ListPitInfo>();
        for (ReaderContext ctx : this.activeReaders.values()) {
            if (!(ctx instanceof PitReaderContext)) continue;
            PitReaderContext context = (PitReaderContext)ctx;
            ListPitInfo pitInfo = new ListPitInfo(context.getPitId(), context.getCreationTime(), context.getKeepAlive());
            pitContextsInfo.add(pitInfo);
        }
        return pitContextsInfo;
    }

    final SearchContext createContext(ReaderContext readerContext, ShardSearchRequest request, SearchShardTask task, boolean includeAggregations) throws IOException {
        DefaultSearchContext context = this.createSearchContext(readerContext, request, this.defaultSearchTimeout, false);
        try {
            if (request.scroll() != null) {
                context.scrollContext().scroll = request.scroll();
            }
            this.parseSource(context, request.source(), includeAggregations);
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            context.setTask(task);
            this.queryPhase.preProcess((SearchExecutionContext)context);
        }
        catch (Exception e) {
            context.close();
            throw e;
        }
        return context;
    }

    public DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout, boolean validate) throws IOException {
        IndexShard baseIndexShard;
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = baseIndexShard = indexService.getShard(request.shardId().getId());
        Engine.SearcherSupplier reader = indexShard.acquireSearcherSupplier();
        ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
        try (ReaderContext readerContext = new ReaderContext(id, (BaseIndexService)indexService, (BaseIndexShard)indexShard, reader, -1L, true);){
            DefaultSearchContext searchContext = this.createSearchContext(readerContext, request, timeout, validate);
            searchContext.addReleasable(readerContext.markAsUsed(0L));
            DefaultSearchContext defaultSearchContext = searchContext;
            return defaultSearchContext;
        }
    }

    public DefaultSearchContext createValidationContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        return this.createSearchContext(request, timeout, true);
    }

    public DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        return this.createSearchContext(request, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DefaultSearchContext createSearchContext(ReaderContext reader, ShardSearchRequest request, TimeValue timeout, boolean validate) throws IOException {
        boolean success = false;
        DefaultSearchContext searchContext = null;
        try {
            SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().getId(), reader.indexShard().shardId(), request.getClusterAlias(), OriginalIndices.NONE);
            searchContext = new DefaultSearchContext(reader, request, shardTarget, this.clusterService, this.bigArrays, () -> ((ThreadPool)this.threadPool).relativeTimeInMillis(), timeout, this.fetchPhase, this.lowLevelCancellation, this.clusterService.state().nodes().getMinNodeVersion(), validate, this.indexSearcherExecutor, this::aggReduceContextBuilder);
            QueryShardContext context = new QueryShardContext(searchContext.getQueryShardContext());
            Rewriteable.rewrite((Rewriteable)request.getRewriteable(), (QueryRewriteContext)context, (boolean)true);
            assert (searchContext.getQueryShardContext().isCacheable());
            success = true;
            if (success) return searchContext;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(searchContext);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable)((Object)searchContext));
        return searchContext;
    }

    private void freeAllContextForIndex(Index index) {
        assert (index != null);
        for (ReaderContext ctx : this.activeReaders.values()) {
            if (!index.equals((Object)ctx.indexShard().shardId().getIndex())) continue;
            this.freeReaderContext(ctx.id());
        }
    }

    public DeletePitResponse freeReaderContextsIfFound(List<PitSearchContextIdForNode> contextIds) {
        ArrayList<DeletePitInfo> deleteResults = new ArrayList<DeletePitInfo>();
        for (PitSearchContextIdForNode contextId : contextIds) {
            try {
                if (this.getReaderContext(contextId.getSearchContextIdForNode().getSearchContextId()) != null) {
                    ReaderContext context = this.removeReaderContext(contextId.getSearchContextIdForNode().getSearchContextId().getId());
                    try {
                        PitReaderContext pitReaderContext = (PitReaderContext)context;
                        if (context == null) {
                            DeletePitInfo deletePitInfo = new DeletePitInfo(true, contextId.getPitId());
                            deleteResults.add(deletePitInfo);
                            continue;
                        }
                        String pitId = pitReaderContext.getPitId();
                        boolean success = context != null;
                        DeletePitInfo deletePitInfo = new DeletePitInfo(success, pitId);
                        deleteResults.add(deletePitInfo);
                        continue;
                    }
                    finally {
                        if (context != null) {
                            context.close();
                        }
                        continue;
                    }
                }
                DeletePitInfo deletePitInfo = new DeletePitInfo(true, contextId.getPitId());
                deleteResults.add(deletePitInfo);
            }
            catch (SearchContextMissingException e) {
                DeletePitInfo deletePitInfo = new DeletePitInfo(true, contextId.getPitId());
                deleteResults.add(deletePitInfo);
            }
        }
        return new DeletePitResponse(deleteResults);
    }

    private long getKeepAlive(ShardSearchRequest request) {
        if (request.scroll() != null) {
            return this.getScrollKeepAlive(request.scroll());
        }
        if (request.keepAlive() != null) {
            if (this.getReaderContext(request.readerId()) instanceof PitReaderContext) {
                this.checkPitKeepAliveLimit(request.keepAlive().millis());
            } else {
                this.checkKeepAliveLimit(request.keepAlive().millis());
            }
            return request.keepAlive().getMillis();
        }
        return request.readerId() == null ? this.defaultKeepAlive : -1L;
    }

    private long getScrollKeepAlive(Scroll scroll) {
        if (scroll != null && scroll.keepAlive() != null) {
            this.checkKeepAliveLimit(scroll.keepAlive().millis());
            return scroll.keepAlive().getMillis();
        }
        return this.defaultKeepAlive;
    }

    private void checkKeepAliveLimit(long keepAlive) {
        if (keepAlive > this.maxKeepAlive) {
            throw new IllegalArgumentException("Keep alive for request (" + String.valueOf(TimeValue.timeValueMillis((long)keepAlive)) + ") is too large. It must be less than (" + String.valueOf(TimeValue.timeValueMillis((long)this.maxKeepAlive)) + "). This limit can be set by changing the [" + SearchServiceSettings.MAX_KEEPALIVE_SETTING.getKey() + "] cluster level setting.");
        }
    }

    private void checkPitKeepAliveLimit(long keepAlive) {
        if (keepAlive > this.maxPitKeepAlive) {
            throw new IllegalArgumentException("Keep alive for request (" + String.valueOf(TimeValue.timeValueMillis((long)keepAlive)) + ") is too large. It must be less than (" + String.valueOf(TimeValue.timeValueMillis((long)this.maxPitKeepAlive)) + "). This limit can be set by changing the [" + SearchServiceSettings.MAX_PIT_KEEPALIVE_SETTING.getKey() + "] cluster level setting.");
        }
    }

    private <T> ActionListener<T> wrapFailureListener(final ActionListener<T> listener, final ReaderContext context, final Releasable releasable) {
        return new ActionListener<T>(){

            public void onResponse(T resp) {
                Releasables.close((Releasable)releasable);
                listener.onResponse(resp);
            }

            public void onFailure(Exception exc) {
                SearchService.this.processFailure(context, exc);
                Releasables.close((Releasable)releasable);
                listener.onFailure(exc);
            }
        };
    }

    private boolean isScrollContext(ReaderContext context) {
        return context instanceof LegacyReaderContext && !context.singleSession();
    }

    private void processFailure(ReaderContext context, Exception exc) {
        if (context.singleSession() || this.isScrollContext(context)) {
            this.freeReaderContext(context.id());
        }
        try {
            if (Lucene.isCorruptionException((Throwable)exc)) {
                context.indexShard().failShard("search execution corruption failure", exc);
            }
        }
        catch (Exception inner) {
            inner.addSuppressed(exc);
            logger.warn("failed to process shard failure to (potentially) send back shard failure on corruption", (Throwable)inner);
        }
    }

    private void parseSource(DefaultSearchContext context, SearchSourceBuilder source, boolean includeAggregations) {
        if (source == null) {
            context.evaluateRequestShouldUseConcurrentSearch();
            return;
        }
        SearchShardTarget shardTarget = context.shardTarget();
        QueryShardContext queryShardContext = context.getQueryShardContext();
        context.from(source.from());
        context.size(source.size());
        HashMap<String, InnerHitContextBuilder> innerHitBuilders = new HashMap<String, InnerHitContextBuilder>();
        if (source.query() != null) {
            InnerHitContextBuilder.extractInnerHits(source.query(), innerHitBuilders);
            context.parsedQuery(queryShardContext.toQuery(source.query()));
        }
        if (source.postFilter() != null) {
            InnerHitContextBuilder.extractInnerHits(source.postFilter(), innerHitBuilders);
            context.parsedPostFilter(queryShardContext.toQuery(source.postFilter()));
        }
        if (innerHitBuilders.size() > 0) {
            for (Map.Entry entry : innerHitBuilders.entrySet()) {
                try {
                    ((InnerHitContextBuilder)entry.getValue()).build(context, context.innerHits());
                }
                catch (IOException e) {
                    throw new SearchException(shardTarget, "failed to build inner_hits", (Throwable)e);
                }
            }
        }
        if (source.sorts() != null) {
            try {
                Optional optionalSort = SortBuilder.buildSort((List)source.sorts(), (QueryShardContext)context.getQueryShardContext());
                if (optionalSort.isPresent()) {
                    context.sort((SortAndFormats)optionalSort.get());
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create sort elements", (Throwable)e);
            }
        }
        context.trackScores(source.trackScores());
        if (source.trackTotalHitsUpTo() != null && source.trackTotalHitsUpTo() != Integer.MAX_VALUE && context.scrollContext() != null) {
            throw new SearchException(shardTarget, "disabling [track_total_hits] is not allowed in a scroll context");
        }
        if (source.trackTotalHitsUpTo() != null) {
            context.trackTotalHitsUpTo(source.trackTotalHitsUpTo());
        }
        if (source.minScore() != null) {
            context.minimumScore(source.minScore().floatValue());
        }
        if (source.timeout() != null) {
            context.timeout(source.timeout());
        }
        context.terminateAfter(source.terminateAfter());
        if (source.aggregations() != null && includeAggregations) {
            ProductionAggregationContext aggContext = new ProductionAggregationContext(queryShardContext, context.parsedQuery() == null ? null : context.parsedQuery().query());
            try {
                AggregatorFactories factories = source.aggregations().build((AggregationContext)aggContext, null);
                context.aggregations(new SearchContextAggregations(factories, this.multiBucketConsumerService.create()));
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to create aggregators", (Throwable)e);
            }
        }
        if (source.suggest() != null) {
            try {
                context.suggest(source.suggest().build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create SuggestionSearchContext", (Throwable)e);
            }
        }
        if (source.rescores() != null) {
            try {
                for (RescorerBuilder rescore : source.rescores()) {
                    context.addRescore(rescore.buildContext(queryShardContext));
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create RescoreSearchContext", (Throwable)e);
            }
        }
        if (source.explain() != null) {
            context.explain(source.explain());
        }
        if (source.fetchSource() != null) {
            context.fetchSourceContext(source.fetchSource());
        }
        if (source.docValueFields() != null) {
            FetchDocValuesContext docValuesContext = FetchDocValuesContext.create(arg_0 -> ((MapperService)context.mapperService()).simpleMatchToFullName(arg_0), (int)context.mapperService().getIndexSettings().getMaxDocvalueFields(), (List)source.docValueFields());
            context.docValuesContext(docValuesContext);
        }
        if (source.fetchFields() != null) {
            FetchFieldsContext fetchFieldsContext = new FetchFieldsContext(source.fetchFields());
            context.fetchFieldsContext(fetchFieldsContext);
        }
        if (source.highlighter() != null) {
            HighlightBuilder highlightBuilder = source.highlighter();
            try {
                context.highlight(highlightBuilder.build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create SearchContextHighlighter", (Throwable)e);
            }
        }
        if (source.scriptFields() != null && source.size() != 0) {
            int maxAllowedScriptFields = context.mapperService().getIndexSettings().getMaxScriptFields();
            if (source.scriptFields().size() > maxAllowedScriptFields) {
                throw new IllegalArgumentException("Trying to retrieve too many script_fields. Must be less than or equal to: [" + maxAllowedScriptFields + "] but was [" + source.scriptFields().size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_SCRIPT_FIELDS_SETTING.getKey() + "] index level setting.");
            }
            for (SearchSourceBuilder.ScriptField field : source.scriptFields()) {
                FieldScript.Factory factory = (FieldScript.Factory)this.scriptService.compile(field.script(), FieldScript.CONTEXT);
                SearchLookup lookup = context.getQueryShardContext().lookup();
                FieldScript.LeafFactory searchScript = factory.newFactory(field.script().getParams(), lookup);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (source.ext() != null) {
            for (SearchExtBuilder searchExtBuilder : source.ext()) {
                context.addSearchExt(searchExtBuilder);
            }
        }
        if (source.version() != null) {
            context.version(source.version());
        }
        if (source.seqNoAndPrimaryTerm() != null) {
            context.seqNoAndPrimaryTerm(source.seqNoAndPrimaryTerm());
        }
        if (source.stats() != null) {
            context.groupStats(source.stats());
        }
        if (!CollectionUtils.isEmpty((Object[])source.searchAfter())) {
            if (context.scrollContext() != null) {
                throw new SearchException(shardTarget, "`search_after` cannot be used in a scroll context.");
            }
            if (context.from() > 0) {
                throw new SearchException(shardTarget, "`from` parameter must be set to 0 when `search_after` is used.");
            }
            FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc((SortAndFormats)context.sort(), (Object[])source.searchAfter());
            context.searchAfter(fieldDoc);
        }
        if (source.slice() != null) {
            if (context.scrollContext() == null && !(context.readerContext() instanceof PitReaderContext)) {
                throw new SearchException(shardTarget, "`slice` cannot be used outside of a scroll context or PIT context");
            }
            context.sliceBuilder(source.slice());
        }
        if (source.storedFields() != null) {
            if (!source.storedFields().fetchFields()) {
                if (context.sourceRequested()) {
                    throw new SearchException(shardTarget, "[stored_fields] cannot be disabled if [_source] is requested");
                }
                if (context.fetchFieldsContext() != null) {
                    throw new SearchException(shardTarget, "[stored_fields] cannot be disabled when using the [fields] option");
                }
            }
            context.storedFieldsContext(source.storedFields());
        }
        if (source.collapse() != null) {
            if (context.scrollContext() != null) {
                throw new SearchException(shardTarget, "cannot use `collapse` in a scroll context");
            }
            if (context.searchAfter() != null) {
                throw new SearchException(shardTarget, "cannot use `collapse` in conjunction with `search_after`");
            }
            if (context.rescore() != null && !context.rescore().isEmpty()) {
                throw new SearchException(shardTarget, "cannot use `collapse` in conjunction with `rescore`");
            }
            CollapseContext collapseContext = source.collapse().build(queryShardContext);
            context.collapse(collapseContext);
        }
        context.evaluateRequestShouldUseConcurrentSearch();
        if (source.profile()) {
            context.setProfilers(new Profilers((ProfilableIndexSearcher)context.searcher(), context.shouldUseConcurrentSearch()));
        }
    }

    private void shortcutDocIdsToLoad(SearchContext context) {
        int[] docIdsToLoad;
        List completionSuggestions;
        int docsOffset = 0;
        Suggest suggest = context.queryResult().suggest();
        int numSuggestDocs = 0;
        if (suggest != null && suggest.hasScoreDocs()) {
            completionSuggestions = suggest.filter(CompletionSuggestion.class);
            for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
        } else {
            completionSuggestions = Collections.emptyList();
        }
        if (context.request().scroll() != null) {
            topDocs = context.queryResult().topDocs().topDocs;
            docIdsToLoad = new int[topDocs.scoreDocs.length + numSuggestDocs];
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                docIdsToLoad[docsOffset++] = topDocs.scoreDocs[i].doc;
            }
        } else {
            topDocs = context.queryResult().topDocs().topDocs;
            if (topDocs.scoreDocs.length < context.from()) {
                docIdsToLoad = new int[numSuggestDocs];
            } else {
                int totalSize = context.from() + context.size();
                docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size()) + numSuggestDocs];
                for (int i = context.from(); i < Math.min(totalSize, topDocs.scoreDocs.length); ++i) {
                    docIdsToLoad[docsOffset++] = topDocs.scoreDocs[i].doc;
                }
            }
        }
        for (CompletionSuggestion completionSuggestion : completionSuggestions) {
            for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                docIdsToLoad[docsOffset++] = option.getDoc().doc;
            }
        }
        context.docIdsToLoad(docIdsToLoad, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, ReaderContext reader, SearchContext context) {
        context.from(context.from() + context.size());
        context.scrollContext().scroll = request.scroll();
    }

    public int getActiveContexts() {
        return this.activeReaders.size();
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, Set<String> resolvedExpressions) {
        return this.indicesService.buildAliasFilter(state, index, resolvedExpressions);
    }

    public void canMatch(ShardSearchRequest request, ActionListener<SearchPhaseResult.CanMatchResponse> listener) {
        try {
            listener.onResponse((Object)this.canMatch(request));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    public SearchPhaseResult.CanMatchResponse canMatch(ShardSearchRequest request) throws IOException {
        return this.canMatch(request, true);
    }

    private SearchPhaseResult.CanMatchResponse canMatch(ShardSearchRequest request, boolean checkRefreshPending) throws IOException {
        Releasable markAsUsed;
        assert (request.searchType() == SearchType.QUERY_THEN_FETCH) : "unexpected search type: " + String.valueOf(request.searchType());
        ReaderContext readerContext = request.readerId() != null ? this.findReaderContext(request.readerId(), (TransportRequest)request) : null;
        try (Releasable ignored = markAsUsed = readerContext != null ? readerContext.markAsUsed(this.getKeepAlive(request)) : () -> {};){
            SearchPhaseResult.CanMatchResponse canMatchResponse;
            block17: {
                boolean hasRefreshPending;
                Engine.Searcher canMatchSearcher;
                BaseIndexService indexService;
                if (readerContext != null) {
                    indexService = readerContext.indexService();
                    canMatchSearcher = readerContext.acquireSearcher("can_match");
                    hasRefreshPending = false;
                } else {
                    indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
                    BaseIndexShard baseIndexShard = indexService.getShard(request.shardId().getId());
                    IndexShard indexShard = (IndexShard)baseIndexShard;
                    hasRefreshPending = indexShard.hasRefreshPending() && checkRefreshPending;
                    canMatchSearcher = indexShard.acquireSearcher("can_match");
                }
                Engine.Searcher ignored2 = canMatchSearcher;
                try {
                    boolean canMatch;
                    MinAndMax minMax;
                    QueryShardContext context = indexService.newQueryShardContext(request.shardId().id(), (IndexSearcher)canMatchSearcher, () -> ((ShardSearchRequest)request).nowInMillis(), request.getClusterAlias(), request.getRuntimeMappings());
                    Rewriteable.rewrite((Rewriteable)request.getRewriteable(), (QueryRewriteContext)context, (boolean)false);
                    boolean aliasFilterCanMatch = !(request.getAliasFilter().getQueryBuilder() instanceof MatchNoneQueryBuilder);
                    FieldSortBuilder sortBuilder = SearchSourceBuilder.getPrimaryFieldSortOrNull((SearchSourceBuilder)request.source());
                    MinAndMax minAndMax = minMax = sortBuilder != null ? FieldSortBuilder.getMinMaxOrNull((QueryShardContext)context, (FieldSortBuilder)sortBuilder) : null;
                    if (SearchService.canRewriteToMatchNone((SearchSourceBuilder)request.source())) {
                        QueryBuilder queryBuilder = request.source().query();
                        canMatch = aliasFilterCanMatch && !(queryBuilder instanceof MatchNoneQueryBuilder);
                    } else {
                        canMatch = aliasFilterCanMatch;
                    }
                    FieldDoc searchAfterFieldDoc = SearchService.getSearchAfterFieldDoc(request, context);
                    Integer trackTotalHitsUpto = request.source() == null ? null : request.source().trackTotalHitsUpTo();
                    canMatch = canMatch && ContextIndexSearcher.canMatchSearchAfter((FieldDoc)searchAfterFieldDoc, (MinAndMax)minMax, (FieldSortBuilder)sortBuilder, (Integer)trackTotalHitsUpto);
                    canMatchResponse = new SearchPhaseResult.CanMatchResponse(canMatch || hasRefreshPending, minMax);
                    if (ignored2 == null) break block17;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored2.close();
            }
            return canMatchResponse;
        }
    }

    private static FieldDoc getSearchAfterFieldDoc(ShardSearchRequest request, QueryShardContext context) throws IOException {
        if (context != null && request != null && request.source() != null && request.source().sorts() != null) {
            List sorts = request.source().sorts();
            Object[] searchAfter = request.source().searchAfter();
            Optional sortOpt = SortBuilder.buildSort((List)sorts, (QueryShardContext)context);
            if (sortOpt.isPresent() && !CollectionUtils.isEmpty((Object[])searchAfter)) {
                return SearchAfterBuilder.buildFieldDoc((SortAndFormats)((SortAndFormats)sortOpt.get()), (Object[])searchAfter);
            }
        }
        return null;
    }

    private void rewriteAndFetchShardRequest(BaseIndexShard shard, ShardSearchRequest request, ActionListener<ShardSearchRequest> listener) {
        ActionListener actionListener = ActionListenerHelper.wrap(r -> {
            if (request.readerId() != null) {
                listener.onResponse((Object)request);
            } else {
                shard.awaitShardSearchActive(b -> listener.onResponse((Object)request));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        Rewriteable.rewriteAndFetch((Rewriteable)request.getRewriteable(), (QueryRewriteContext)this.indicesService.getRewriteContext(() -> ((ShardSearchRequest)request).nowInMillis()), (ActionListener)actionListener);
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis) {
        return this.indicesService.getRewriteContext(nowInMillis);
    }

    public QueryRewriteContext getValidationRewriteContext(LongSupplier nowInMillis) {
        return this.indicesService.getValidationRewriteContext(nowInMillis);
    }

    public IndicesService getIndicesService() {
        return this.indicesService;
    }

    public InternalAggregation.ReduceContextBuilder aggReduceContextBuilder(final SearchSourceBuilder searchSourceBuilder) {
        return new InternalAggregation.ReduceContextBuilder(){

            public InternalAggregation.ReduceContext forPartialReduction() {
                return InternalAggregation.ReduceContext.forPartialReduction((BigArrays)SearchService.this.bigArrays, (ScriptService)SearchService.this.scriptService, () -> SearchService.requestToPipelineTree(searchSourceBuilder));
            }

            public InternalAggregation.ReduceContext forFinalReduction() {
                PipelineAggregator.PipelineTree pipelineTree = SearchService.requestToPipelineTree(searchSourceBuilder);
                return InternalAggregation.ReduceContext.forFinalReduction((BigArrays)SearchService.this.bigArrays, (ScriptService)SearchService.this.scriptService, (IntConsumer)SearchService.this.multiBucketConsumerService.create(), (PipelineAggregator.PipelineTree)pipelineTree);
            }
        };
    }

    private static PipelineAggregator.PipelineTree requestToPipelineTree(SearchSourceBuilder searchSourceBuilder) {
        if (searchSourceBuilder == null || searchSourceBuilder.aggregations() == null) {
            return PipelineAggregator.PipelineTree.EMPTY;
        }
        return searchSourceBuilder.aggregations().buildPipelineTree();
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            for (ReaderContext context : SearchService.this.activeReaders.values()) {
                if (!context.isExpired()) continue;
                logger.debug("freeing search context [{}]", (Object)context.id());
                SearchService.this.freeReaderContext(context.id());
            }
        }
    }

    private static final class SearchOperationListenerExecutor
    implements AutoCloseable {
        private final SearchOperationListener listener;
        private final SearchContext context;
        private final long time;
        private final boolean fetch;
        private long afterQueryTime = -1L;
        private boolean closed = false;

        SearchOperationListenerExecutor(SearchContext context) {
            this(context, false, System.nanoTime());
        }

        SearchOperationListenerExecutor(SearchContext context, boolean fetch, long startTime) {
            this.listener = context.indexShard().getSearchOperationListener();
            this.context = context;
            this.time = startTime;
            this.fetch = fetch;
            if (fetch) {
                this.listener.onPreFetchPhase((SearchExecutionContext)context);
            } else {
                this.listener.onPreQueryPhase((SearchExecutionContext)context);
            }
        }

        long success() {
            this.afterQueryTime = System.nanoTime();
            return this.afterQueryTime;
        }

        @Override
        public void close() {
            assert (!this.closed) : "already closed - while technically ok double closing is a likely a bug in this case";
            if (!this.closed) {
                this.closed = true;
                if (this.afterQueryTime != -1L) {
                    if (this.fetch) {
                        this.listener.onFetchPhase((SearchExecutionContext)this.context, this.afterQueryTime - this.time);
                    } else {
                        this.listener.onQueryPhase((SearchExecutionContext)this.context, this.afterQueryTime - this.time);
                    }
                } else if (this.fetch) {
                    this.listener.onFailedFetchPhase((SearchExecutionContext)this.context);
                } else {
                    this.listener.onFailedQueryPhase((SearchExecutionContext)this.context);
                }
            }
        }
    }
}

