/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import io.skylite.common.CheckedBiConsumer;
import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.Aggregations;
import io.skylite.core.aggregations.bucket.MultiBucketsAggregation;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.search.aggregations.ParsedAggregation;

public abstract class ParsedMultiBucketAggregation<B extends MultiBucketsAggregation.Bucket>
extends ParsedAggregation
implements MultiBucketsAggregation {
    protected final List<B> buckets = new ArrayList<B>();
    protected boolean keyed = false;

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (MultiBucketsAggregation.Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    protected static void declareMultiBucketAggregationFields(ObjectParser<? extends ParsedMultiBucketAggregation, Void> objectParser, CheckedFunction<XContentParser, ParsedBucket, IOException> bucketParser, CheckedFunction<XContentParser, ParsedBucket, IOException> keyedBucketParser) {
        ParsedMultiBucketAggregation.declareAggregationFields(objectParser);
        objectParser.declareField((parser, aggregation, context) -> {
            block3: {
                XContentParser.Token token;
                block2: {
                    token = parser.currentToken();
                    if (token != XContentParser.Token.START_OBJECT) break block2;
                    aggregation.keyed = true;
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        aggregation.buckets.add(keyedBucketParser.apply((Object)parser));
                    }
                    break block3;
                }
                if (token != XContentParser.Token.START_ARRAY) break block3;
                aggregation.keyed = false;
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    aggregation.buckets.add(bucketParser.apply((Object)parser));
                }
            }
        }, Aggregation.CommonFields.BUCKETS, ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public static abstract class ParsedBucket
    implements MultiBucketsAggregation.Bucket {
        private Aggregations aggregations;
        private String keyAsString;
        private long docCount;
        private boolean keyed;

        protected void setKeyAsString(String keyAsString) {
            this.keyAsString = keyAsString;
        }

        public String getKeyAsString() {
            return this.keyAsString;
        }

        protected void setDocCount(long docCount) {
            this.docCount = docCount;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public void setKeyed(boolean keyed) {
            this.keyed = keyed;
        }

        protected boolean isKeyed() {
            return this.keyed;
        }

        protected void setAggregations(Aggregations aggregations) {
            this.aggregations = aggregations;
        }

        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.keyed) {
                builder.startObject(this.getKeyAsString());
            } else {
                builder.startObject();
            }
            if (this.keyAsString != null) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            }
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKey());
        }

        protected static <B extends ParsedBucket> B parseXContent(XContentParser parser, boolean keyed, Supplier<B> bucketSupplier, CheckedBiConsumer<XContentParser, B, IOException> keyConsumer) throws IOException {
            ParsedBucket bucket = (ParsedBucket)bucketSupplier.get();
            bucket.setKeyed(keyed);
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (keyed) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            }
            ArrayList aggregations = new ArrayList();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setKeyAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        keyConsumer.accept((Object)parser, (Object)bucket);
                        continue;
                    }
                    if (!Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) continue;
                    bucket.setDocCount(parser.longValue());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                    keyConsumer.accept((Object)parser, (Object)bucket);
                    continue;
                }
                XContentParserUtils.parseTypedKeysObject((XContentParser)parser, (String)"#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return (B)bucket;
        }
    }
}

