/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import io.skylite.common.CheckedFunction;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.BitArray;
import io.skylite.core.common.util.DoubleArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.mapper.MappedFieldType;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.opensearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;

class DoubleValuesSource
extends SingleDimensionValuesSource<Double> {
    private final CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException> docValuesFunc;
    private final BitArray bits;
    private DoubleArray values;
    private double currentValue;
    private boolean missingCurrentValue;

    DoubleValuesSource(BigArrays bigArrays, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, format, fieldType, missingBucket, missingOrder, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.bits = missingBucket ? new BitArray(100L, bigArrays) : null;
        this.values = bigArrays.newDoubleArray((long)Math.min(size, 100), false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        if (this.missingBucket && this.missingCurrentValue) {
            this.bits.clear((long)slot);
        } else {
            assert (!this.missingCurrentValue);
            if (this.missingBucket) {
                this.bits.set((long)slot);
            }
            this.values.set((long)slot, this.currentValue);
        }
    }

    @Override
    int compare(int from, int to) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> !this.bits.get((long)from), () -> !this.bits.get((long)to), this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.values.get((long)from), this.values.get((long)to));
    }

    @Override
    int compareCurrent(int slot) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.missingCurrentValue, () -> !this.bits.get((long)slot), this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.currentValue, this.values.get((long)slot));
    }

    @Override
    int compareCurrentWithAfter() {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.missingCurrentValue, () -> this.afterValue == null, this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.currentValue, (Double)this.afterValue);
    }

    @Override
    int hashCode(int slot) {
        if (this.missingBucket && !this.bits.get((long)slot)) {
            return 0;
        }
        return Double.hashCode(this.values.get((long)slot));
    }

    @Override
    int hashCodeCurrent() {
        if (this.missingCurrentValue) {
            return 0;
        }
        return Double.hashCode(this.currentValue);
    }

    private int compareValues(double v1, double v2) {
        return Double.compare(v1, v2) * this.reverseMul;
    }

    @Override
    void setAfter(Comparable value) {
        this.afterValue = this.missingBucket && value == null ? null : (value instanceof Number ? Double.valueOf(((Number)((Object)value)).doubleValue()) : Double.valueOf(this.format.parseDouble(value.toString(), false, () -> {
            throw new IllegalArgumentException("now() is not supported in [after] key");
        })));
    }

    @Override
    Double toComparable(int slot) {
        if (this.missingBucket && !this.bits.get((long)slot)) {
            return null;
        }
        assert (!this.missingBucket || this.bits.get((long)slot));
        return this.values.get((long)slot);
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedNumericDoubleValues dvs = (SortedNumericDoubleValues)this.docValuesFunc.apply((Object)context);
        return new LeafBucketCollector(){

            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        DoubleValuesSource.this.currentValue = dvs.nextValue();
                        DoubleValuesSource.this.missingCurrentValue = false;
                        next.collect(doc, bucket);
                    }
                } else if (DoubleValuesSource.this.missingBucket) {
                    DoubleValuesSource.this.missingCurrentValue = true;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != Double.class) {
            throw new IllegalArgumentException("Expected Double, got " + String.valueOf(value.getClass()));
        }
        this.currentValue = (Double)value;
        return new LeafBucketCollector(this){

            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        return null;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, this.bits});
    }
}

