/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;

class HistogramValuesSource
extends NumericValuesSource {
    private final NumericValuesSource vs;
    private final double interval;

    HistogramValuesSource(NumericValuesSource vs, double interval) {
        this.vs = vs;
        this.interval = interval;
    }

    public boolean isFloatingPoint() {
        return true;
    }

    public boolean isBigInteger() {
        return false;
    }

    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
        final SortedNumericDoubleValues values = this.vs.doubleValues(context);
        return new SortedNumericDoubleValues(){

            public double nextValue() throws IOException {
                return Math.floor(values.nextValue() / HistogramValuesSource.this.interval) * HistogramValuesSource.this.interval;
            }

            public int docValueCount() {
                return values.docValueCount();
            }

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }
        };
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }

    public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }
}

