/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.common.Rounding;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;

class RoundingValuesSource
extends NumericValuesSource {
    private final NumericValuesSource vs;
    private final Rounding.Prepared rounding;

    RoundingValuesSource(NumericValuesSource vs, Rounding.Prepared rounding) {
        this.vs = vs;
        this.rounding = rounding;
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public boolean isBigInteger() {
        return false;
    }

    public long round(long value) {
        return this.rounding.round(value);
    }

    public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
        final SortedNumericDocValues values = this.vs.longValues(context);
        return new SortedNumericDocValues(){

            public long nextValue() throws IOException {
                return RoundingValuesSource.this.round(values.nextValue());
            }

            public int docValueCount() {
                return values.docValueCount();
            }

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public int docID() {
                return values.docID();
            }

            public int nextDoc() throws IOException {
                return values.nextDoc();
            }

            public int advance(int target) throws IOException {
                return values.advance(target);
            }

            public long cost() {
                return values.cost();
            }
        };
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }

    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }
}

