/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.List;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.opensearch.search.aggregations.bucket.composite.BinaryValuesSource;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.opensearch.search.aggregations.bucket.composite.DoubleValuesSource;
import org.opensearch.search.aggregations.bucket.composite.GlobalOrdinalValuesSource;
import org.opensearch.search.aggregations.bucket.composite.LongValuesSource;
import org.opensearch.search.aggregations.bucket.composite.UnsignedLongValuesSource;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;

public class TermsValuesSourceBuilder
extends CompositeValuesSourceBuilder<TermsValuesSourceBuilder> {
    static final String TYPE = "terms";
    static final AggregationRegistry.RegistryKey<TermsCompositeSupplier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("terms", TermsCompositeSupplier.class);
    private static final ObjectParser<TermsValuesSourceBuilder, Void> PARSER = new ObjectParser("terms");

    static TermsValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return (TermsValuesSourceBuilder)PARSER.parse(parser, (Object)new TermsValuesSourceBuilder(name), null);
    }

    public TermsValuesSourceBuilder(String name) {
        super(name);
    }

    protected TermsValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    @Override
    public String type() {
        return TYPE;
    }

    static void register(AggregationRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), (valuesSourceConfig, name, hasScript, format, missingBucket, missingOrder, order) -> {
            DocValueFormat docValueFormat = format == null && valuesSourceConfig.valueSourceType() == CoreValuesSourceType.DATE ? DocValueFormat.RAW : valuesSourceConfig.format();
            return new CompositeValuesSourceConfig(name, valuesSourceConfig.fieldType(), valuesSourceConfig.getValuesSource(), docValueFormat, order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                NumericValuesSource vs = (NumericValuesSource)compositeValuesSourceConfig.valuesSource();
                if (vs.isFloatingPoint()) {
                    return new DoubleValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException>)((CheckedFunction)arg_0 -> ((NumericValuesSource)vs).doubleValues(arg_0)), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
                }
                if (vs.isBigInteger()) {
                    return new UnsignedLongValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException>)((CheckedFunction)arg_0 -> ((NumericValuesSource)vs).longValues(arg_0)), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
                }
                LongUnaryOperator rounding = LongUnaryOperator.identity();
                return new LongValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException>)((CheckedFunction)arg_0 -> ((NumericValuesSource)vs).longValues(arg_0)), rounding, compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), (valuesSourceConfig, name, hasScript, format, missingBucket, missingOrder, order) -> new CompositeValuesSourceConfig(name, valuesSourceConfig.fieldType(), valuesSourceConfig.getValuesSource(), valuesSourceConfig.format(), order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
            if (valuesSourceConfig.hasGlobalOrdinals() && reader instanceof DirectoryReader) {
                BytesValuesSource.WithOrdinals vs = (BytesValuesSource.WithOrdinals)compositeValuesSourceConfig.valuesSource();
                return new GlobalOrdinalValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException>)((CheckedFunction)arg_0 -> ((BytesValuesSource.WithOrdinals)vs).globalOrdinalsValues(arg_0)), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            }
            BytesValuesSource vs = (BytesValuesSource)compositeValuesSourceConfig.valuesSource();
            return new BinaryValuesSource(bigArrays, addRequestCircuitBreakerBytes, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException>)((CheckedFunction)arg_0 -> ((BytesValuesSource)vs).bytesValues(arg_0)), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
        }), false);
    }

    @Override
    protected ValuesSourceType getDefaultValuesSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(AggregationRegistry registry, ValuesSourceConfig config) throws IOException {
        return ((TermsCompositeSupplier)registry.getAggregator(REGISTRY_KEY, config)).apply(config, this.name, this.script() != null, this.format(), this.missingBucket(), this.missingOrder(), this.order());
    }

    static {
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface TermsCompositeSupplier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, String var2, boolean var3, String var4, boolean var5, MissingOrder var6, SortOrder var7);
    }
}

