/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import io.skylite.common.CheckedFunction;
import io.skylite.common.Numbers;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.BitArray;
import io.skylite.core.common.util.LongArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.NumberFieldMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.opensearch.search.aggregations.bucket.composite.LongValuesSource;
import org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.opensearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.opensearch.search.aggregations.bucket.composite.UnsignedLongPointsSortedDocsProducer;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;

public class UnsignedLongValuesSource
extends SingleDimensionValuesSource<BigInteger> {
    private final BigArrays bigArrays;
    private final CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException> docValuesFunc;
    private BitArray bits;
    private LongArray values;
    private long currentValue;
    private boolean missingCurrentValue;

    public UnsignedLongValuesSource(BigArrays bigArrays, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, format, fieldType, missingBucket, missingOrder, size, reverseMul);
        this.bigArrays = bigArrays;
        this.docValuesFunc = docValuesFunc;
        this.bits = missingBucket ? new BitArray((long)Math.min(size, 100), bigArrays) : null;
        this.values = bigArrays.newLongArray((long)Math.min(size, 100), false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        if (this.missingBucket && this.missingCurrentValue) {
            this.bits.clear((long)slot);
        } else {
            assert (!this.missingCurrentValue);
            if (this.missingBucket) {
                this.bits.set((long)slot);
            }
            this.values.set((long)slot, this.currentValue);
        }
    }

    @Override
    int compare(int from, int to) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> !this.bits.get((long)from), () -> !this.bits.get((long)to), this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.values.get((long)from), this.values.get((long)to));
    }

    @Override
    int compareCurrent(int slot) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.missingCurrentValue, () -> !this.bits.get((long)slot), this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.currentValue, this.values.get((long)slot));
    }

    @Override
    int compareCurrentWithAfter() {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.missingCurrentValue, () -> Objects.isNull(this.afterValue), this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.currentValue, ((BigInteger)this.afterValue).longValue());
    }

    @Override
    int hashCode(int slot) {
        if (this.missingBucket && !this.bits.get((long)slot)) {
            return 0;
        }
        return Long.hashCode(this.values.get((long)slot));
    }

    @Override
    int hashCodeCurrent() {
        if (this.missingCurrentValue) {
            return 0;
        }
        return Long.hashCode(this.currentValue);
    }

    @Override
    protected void setAfter(Comparable value) {
        this.afterValue = this.missingBucket && value == null ? null : this.format.parseUnsignedLong(value.toString(), false, () -> {
            throw new IllegalArgumentException("now() is not supported in [after] key");
        });
    }

    @Override
    BigInteger toComparable(int slot) {
        if (this.missingBucket && !this.bits.get((long)slot)) {
            return null;
        }
        return Numbers.toUnsignedBigInteger((long)this.values.get((long)slot));
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedNumericDocValues dvs = (SortedNumericDocValues)this.docValuesFunc.apply((Object)context);
        return new LeafBucketCollector(){

            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        UnsignedLongValuesSource.this.currentValue = dvs.nextValue();
                        UnsignedLongValuesSource.this.missingCurrentValue = false;
                        next.collect(doc, bucket);
                    }
                } else if (UnsignedLongValuesSource.this.missingBucket) {
                    UnsignedLongValuesSource.this.missingCurrentValue = true;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != Long.class) {
            throw new IllegalArgumentException("Expected Long, got " + String.valueOf(value.getClass()));
        }
        this.currentValue = (Long)value;
        return new LeafBucketCollector(this){

            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, this.bits});
    }

    private int compareValues(long v1, long v2) {
        return Long.compareUnsigned(v1, v2) * this.reverseMul;
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        NumberFieldMapper.NumberFieldType ft;
        byte[] upperPoint;
        byte[] lowerPoint;
        query = LongValuesSource.extractQuery(query);
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !LongValuesSource.checkMatchAllOrRangeQuery(query, this.fieldType.name())) {
            return null;
        }
        if (query instanceof PointRangeQuery) {
            PointRangeQuery rangeQuery = (PointRangeQuery)query;
            lowerPoint = rangeQuery.getLowerPoint();
            upperPoint = rangeQuery.getUpperPoint();
        } else {
            lowerPoint = null;
            upperPoint = null;
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType && (ft = (NumberFieldMapper.NumberFieldType)this.fieldType).typeName() == "unsigned_long") {
            return new UnsignedLongPointsSortedDocsProducer(this.fieldType.name(), lowerPoint, upperPoint);
        }
        return null;
    }
}

