/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filter;

import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.bucket.SingleBucketAggregator;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.filter.InternalFilter;

public class FilterAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final Supplier<Weight> filter;

    public FilterAggregator(String name, Supplier<Weight> filter, AggregatorFactories factories, SearchExecutionContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality, metadata);
        this.filter = filter;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final Bits bits = Lucene.asSequentialAccessBits((int)ctx.reader().maxDoc(), (ScorerSupplier)this.filter.get().scorerSupplier(ctx));
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bits.get(doc)) {
                    FilterAggregator.this.collectBucket(sub, doc, bucket);
                }
            }
        };
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalFilter(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalFilter(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }
}

