/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.global;

import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.bucket.SingleBucketAggregator;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.global.InternalGlobal;

public class GlobalAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    public GlobalAggregator(String name, AggregatorFactories subFactories, SearchExecutionContext aggregationContext, Map<String, Object> metadata) throws IOException {
        super(name, subFactories, aggregationContext, null, CardinalityUpperBound.ONE, metadata);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L) : "global aggregator can only be a top level aggregator";
                GlobalAggregator.this.collectBucket(sub, doc, bucket);
            }
        };
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        assert (owningBucketOrds.length == 1 && owningBucketOrds[0] == 0L) : "global aggregator can only be a top level aggregator";
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalGlobal(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    public InternalAggregation buildEmptyAggregation() {
        throw new UnsupportedOperationException("global aggregations cannot serve as sub-aggregations, hence should never be called on #buildEmptyAggregations");
    }
}

