/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.common.Nullable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.bucket.terms.LongKeyedBucketOrds;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.Rounding;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.histogram.SizedBucketAggregator;

class DateHistogramAggregator
extends BucketsAggregator
implements SizedBucketAggregator {
    private final NumericValuesSource valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding.Prepared preparedRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final LongKeyedBucketOrds bucketOrds;

    DateHistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, BucketOrder order, boolean keyed, long minDocCount, @Nullable LongBounds extendedBounds, @Nullable LongBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchExecutionContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, CardinalityUpperBound.MANY, metadata);
        this.rounding = rounding;
        this.preparedRounding = (Rounding.Prepared)valuesSourceConfig.roundingPreparer().apply(rounding);
        this.order = order;
        order.validate((Aggregator)this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.valuesSource = valuesSourceConfig.hasValues() ? (NumericValuesSource)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.bucketOrds = LongKeyedBucketOrds.build((BigArrays)this.context.bigArrays(), (CardinalityUpperBound)cardinality);
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = DateHistogramAggregator.this.preparedRounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        if (DateHistogramAggregator.this.hardBounds == null || DateHistogramAggregator.this.hardBounds.contain(rounded)) {
                            long bucketOrd = DateHistogramAggregator.this.bucketOrds.add(owningBucketOrd, rounded);
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                DateHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                DateHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                        previousRounded = rounded;
                    }
                }
            }
        };
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalDateHistogram.Bucket(bucketValue, docCount, this.keyed, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort((List)buckets, (Comparator)BucketOrder.key((boolean)true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
        });
    }

    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("total_buckets", this.bucketOrds.size());
    }

    @Override
    public double bucketSize(long bucket, Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            return this.preparedRounding.roundingSize(this.bucketOrds.get(bucket), unitSize);
        }
        return 1.0;
    }
}

