/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.Rounding;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationSupplier;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.DateRangeHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public final class DateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final Rounding rounding;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(DateHistogramAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), DateHistogramAggregator::new, true);
        builder.register(DateHistogramAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.RANGE, DateRangeHistogramAggregator::new, true);
    }

    public DateHistogramAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, boolean keyed, long minDocCount, Rounding rounding, LongBounds extendedBounds, LongBounds hardBounds, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.rounding = rounding;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        DateHistogramAggregationSupplier aggregatorSupplier = (DateHistogramAggregationSupplier)this.context.getAggregationRegistry().getAggregator(DateHistogramAggregationBuilder.REGISTRY_KEY, this.config);
        return aggregatorSupplier.build(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new DateHistogramAggregator(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

