/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.Aggregations;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.search.aggregations.ParsedMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;

public class ParsedVariableWidthHistogram
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Histogram {
    private static ObjectParser<ParsedVariableWidthHistogram, Void> PARSER = new ObjectParser(ParsedVariableWidthHistogram.class.getSimpleName(), true, ParsedVariableWidthHistogram::new);

    public String getType() {
        return "variable_width_histogram";
    }

    @Override
    public List<? extends Histogram.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedVariableWidthHistogram fromXContent(XContentParser parser, String name) throws IOException {
        ParsedVariableWidthHistogram aggregation = (ParsedVariableWidthHistogram)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedVariableWidthHistogram.declareMultiBucketAggregationFields(PARSER, (CheckedFunction<XContentParser, ParsedMultiBucketAggregation.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, false)), (CheckedFunction<XContentParser, ParsedMultiBucketAggregation.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, true)));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Histogram.Bucket {
        private Double key;
        private Double min;
        private Double max;
        private String minAsString;
        private String maxAsString;

        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Double.toString(this.key);
            }
            return null;
        }

        public void setMin(Double min) {
            this.min = min;
        }

        public void setMinAsString(String minAsString) {
            this.minAsString = minAsString;
        }

        public double getMin() {
            return this.min;
        }

        public String getMinAsString() {
            if (this.minAsString != null) {
                return this.minAsString;
            }
            if (this.min != null) {
                return Double.toString(this.min);
            }
            return null;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public void setMaxAsString(String maxAsString) {
            this.maxAsString = maxAsString;
        }

        public double getMax() {
            return this.max;
        }

        public String getMaxAsString() {
            if (this.maxAsString != null) {
                return this.maxAsString;
            }
            if (this.max != null) {
                return Double.toString(this.max);
            }
            return null;
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            ParsedBucket bucket = new ParsedBucket();
            bucket.setKeyed(keyed);
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (keyed) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            }
            ArrayList aggregations = new ArrayList();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setKeyAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        bucket.key = parser.doubleValue();
                        continue;
                    }
                    if (Aggregation.CommonFields.MIN_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setMinAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.MIN.getPreferredName().equals(currentFieldName)) {
                        bucket.setMin(parser.doubleValue());
                        continue;
                    }
                    if (Aggregation.CommonFields.MAX_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setMaxAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.MAX.getPreferredName().equals(currentFieldName)) {
                        bucket.setMax(parser.doubleValue());
                        continue;
                    }
                    if (!Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) continue;
                    bucket.setDocCount(parser.longValue());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                    bucket.key = parser.doubleValue();
                    continue;
                }
                XContentParserUtils.parseTypedKeysObject((XContentParser)parser, (String)"#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return bucket;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.isKeyed()) {
                builder.startObject(this.getKeyAsString());
            } else {
                builder.startObject();
            }
            if (this.minAsString != null) {
                builder.field(Aggregation.CommonFields.MIN_AS_STRING.getPreferredName(), this.minAsString);
            }
            builder.field(Aggregation.CommonFields.MIN.getPreferredName(), this.getMin());
            if (super.getKeyAsString() != null) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            }
            this.keyToXContent(builder);
            if (this.maxAsString != null) {
                builder.field(Aggregation.CommonFields.MAX_AS_STRING.getPreferredName(), this.maxAsString);
            }
            builder.field(Aggregation.CommonFields.MAX.getPreferredName(), this.getMax());
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

