/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.common.Nullable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.DoubleArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.aggregations.bucket.MergingBucketsDeferringCollector;
import org.opensearch.search.aggregations.bucket.histogram.InternalVariableWidthHistogram;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregator;

public class VariableWidthHistogramAggregator
extends DeferableBucketAggregator {
    private final NumericValuesSource valuesSource;
    private final DocValueFormat formatter;
    private final int numBuckets;
    private final int shardSize;
    private final int bufferLimit;
    final BigArrays bigArrays;
    private CollectionPhase collector;
    private MergingBucketsDeferringCollector deferringCollector;

    VariableWidthHistogramAggregator(String name, AggregatorFactories factories, int numBuckets, int shardSize, int initialBuffer, @Nullable ValuesSourceConfig valuesSourceConfig, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.numBuckets = numBuckets;
        this.valuesSource = (NumericValuesSource)valuesSourceConfig.getValuesSource();
        this.formatter = valuesSourceConfig.format();
        this.shardSize = shardSize;
        this.bufferLimit = initialBuffer;
        this.bigArrays = context.bigArrays();
        this.collector = new BufferValuesPhase(this.bufferLimit);
        String scoringAgg = this.subAggsNeedScore();
        String nestedAgg = this.descendsFromNestedAggregator(parent);
        if (scoringAgg != null && nestedAgg != null) {
            throw new IllegalStateException("VariableWidthHistogram agg [" + this.name() + "] is the child of the nested agg [" + nestedAgg + "], and also has a scoring child agg [" + scoringAgg + "].  This combination is not supported because it requires executing in [depth_first] mode, which the VariableWidthHistogram agg cannot do.");
        }
    }

    private String subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return subAgg.name();
        }
        return null;
    }

    private String descendsFromNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == NestedAggregator.class) {
                return parent.name();
            }
            parent = parent.parent();
        }
        return null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.deferringCollector = new MergingBucketsDeferringCollector(this.context, VariableWidthHistogramAggregator.descendsFromGlobalAggregator(this.parent()));
        return this.deferringCollector;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double prevVal = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < valuesCount; ++i) {
                        double val = values.nextValue();
                        assert (val >= prevVal);
                        if (val == prevVal) continue;
                        VariableWidthHistogramAggregator.this.collector = VariableWidthHistogramAggregator.this.collector.collectValue(sub, doc, val);
                    }
                }
            }
        };
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        int numClusters = this.collector.finalNumBuckets();
        long[] bucketOrdsToCollect = new long[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            bucketOrdsToCollect[i] = i;
        }
        InternalAggregations[] subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        ArrayList<InternalVariableWidthHistogram.Bucket> buckets = new ArrayList<InternalVariableWidthHistogram.Bucket>(numClusters);
        for (int bucketOrd = 0; bucketOrd < numClusters; ++bucketOrd) {
            buckets.add(this.collector.buildBucket(bucketOrd, subAggregationResults[bucketOrd]));
        }
        Function<List, InternalAggregation> resultBuilder = bucketsToFormat -> {
            CollectionUtil.introSort((List)bucketsToFormat, (Comparator)BucketOrder.key((boolean)true).comparator());
            InternalVariableWidthHistogram.EmptyBucketInfo emptyBucketInfo = new InternalVariableWidthHistogram.EmptyBucketInfo(this.buildEmptySubAggregations());
            return new InternalVariableWidthHistogram(this.name, (List<InternalVariableWidthHistogram.Bucket>)bucketsToFormat, emptyBucketInfo, this.numBuckets, this.formatter, this.metadata());
        };
        return new InternalAggregation[]{resultBuilder.apply(buckets)};
    }

    public InternalAggregation buildEmptyAggregation() {
        InternalVariableWidthHistogram.EmptyBucketInfo emptyBucketInfo = new InternalVariableWidthHistogram.EmptyBucketInfo(this.buildEmptySubAggregations());
        return new InternalVariableWidthHistogram(this.name(), Collections.emptyList(), emptyBucketInfo, this.numBuckets, this.formatter, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.collector);
    }

    public static int mergePhaseInitialBucketCount(int shardSize) {
        return (int)((long)shardSize * 3L / 4L);
    }

    private class BufferValuesPhase
    extends CollectionPhase {
        private DoubleArray buffer;
        private int bufferSize;
        private int bufferLimit;
        private MergeBucketsPhase mergeBucketsPhase;

        BufferValuesPhase(int bufferLimit) {
            super(VariableWidthHistogramAggregator.this);
            this.buffer = VariableWidthHistogramAggregator.this.bigArrays.newDoubleArray(1L);
            this.bufferSize = 0;
            this.bufferLimit = bufferLimit;
            this.mergeBucketsPhase = null;
        }

        @Override
        public CollectionPhase collectValue(LeafBucketCollector sub, int doc, double val) throws IOException {
            if (this.bufferSize < this.bufferLimit) {
                this.buffer = VariableWidthHistogramAggregator.this.bigArrays.grow(this.buffer, (long)(this.bufferSize + 1));
                this.buffer.set((long)this.bufferSize, val);
                VariableWidthHistogramAggregator.this.collectBucket(sub, doc, this.bufferSize);
                ++this.bufferSize;
            }
            if (this.bufferSize == this.bufferLimit) {
                MergeBucketsPhase mergeBuckets = new MergeBucketsPhase(this.buffer, this.bufferSize);
                Releasables.close((Releasable)this);
                return mergeBuckets;
            }
            return this;
        }

        @Override
        int finalNumBuckets() {
            return this.getMergeBucketPhase().finalNumBuckets();
        }

        @Override
        InternalVariableWidthHistogram.Bucket buildBucket(int bucketOrd, InternalAggregations subAggregations) throws IOException {
            InternalVariableWidthHistogram.Bucket bucket = this.getMergeBucketPhase().buildBucket(bucketOrd, subAggregations);
            return bucket;
        }

        MergeBucketsPhase getMergeBucketPhase() {
            if (this.mergeBucketsPhase == null) {
                this.mergeBucketsPhase = new MergeBucketsPhase(this.buffer, this.bufferSize);
            }
            return this.mergeBucketsPhase;
        }

        public void close() {
            if (this.mergeBucketsPhase != null) {
                Releasables.close((Releasable)this.mergeBucketsPhase);
            }
            Releasables.close((Releasable)this.buffer);
        }
    }

    private abstract class CollectionPhase
    implements Releasable {
        private CollectionPhase(VariableWidthHistogramAggregator variableWidthHistogramAggregator) {
        }

        abstract CollectionPhase collectValue(LeafBucketCollector var1, int var2, double var3) throws IOException;

        abstract int finalNumBuckets();

        abstract InternalVariableWidthHistogram.Bucket buildBucket(int var1, InternalAggregations var2) throws IOException;
    }

    private class MergeBucketsPhase
    extends CollectionPhase {
        public DoubleArray clusterMaxes;
        public DoubleArray clusterMins;
        public DoubleArray clusterCentroids;
        public DoubleArray clusterSizes;
        public int numClusters;
        private double avgBucketDistance;

        MergeBucketsPhase(DoubleArray buffer, int bufferSize) {
            super(VariableWidthHistogramAggregator.this);
            this.bucketBufferedDocs(buffer, bufferSize, VariableWidthHistogramAggregator.mergePhaseInitialBucketCount(VariableWidthHistogramAggregator.this.shardSize));
            if (bufferSize > 1) {
                this.updateAvgBucketDistance();
            }
        }

        private void bucketBufferedDocs(DoubleArray buffer, int bufferSize, int numBuckets) {
            this.clusterMins = VariableWidthHistogramAggregator.this.bigArrays.newDoubleArray(1L);
            this.clusterMaxes = VariableWidthHistogramAggregator.this.bigArrays.newDoubleArray(1L);
            this.clusterCentroids = VariableWidthHistogramAggregator.this.bigArrays.newDoubleArray(1L);
            this.clusterSizes = VariableWidthHistogramAggregator.this.bigArrays.newDoubleArray(1L);
            this.numClusters = 0;
            ClusterSorter sorter = new ClusterSorter(this, buffer, bufferSize);
            long[] mergeMap = sorter.generateMergeMap();
            int docsPerBucket = (int)Math.ceil((double)bufferSize / (double)numBuckets);
            int bucketOrd = 0;
            for (int i = 0; i < mergeMap.length; ++i) {
                double val = buffer.get(mergeMap[i]);
                mergeMap[i] = (int)(mergeMap[i] / (long)docsPerBucket);
                if (bucketOrd == this.numClusters) {
                    this.createAndAppendNewCluster(val);
                } else {
                    this.addToCluster(bucketOrd, val);
                }
                if ((i + 1) % docsPerBucket != 0) continue;
                ++bucketOrd;
            }
            VariableWidthHistogramAggregator.this.mergeBuckets(mergeMap, bucketOrd + 1);
            if (VariableWidthHistogramAggregator.this.deferringCollector != null) {
                VariableWidthHistogramAggregator.this.deferringCollector.mergeBuckets(mergeMap);
            }
        }

        @Override
        public CollectionPhase collectValue(LeafBucketCollector sub, int doc, double val) throws IOException {
            int bucketOrd = this.getNearestBucket(val);
            double distance = Math.abs(this.clusterCentroids.get((long)bucketOrd) - val);
            if (bucketOrd == -1 || distance > 2.0 * this.avgBucketDistance && this.numClusters < VariableWidthHistogramAggregator.this.shardSize) {
                this.createAndAppendNewCluster(val);
                VariableWidthHistogramAggregator.this.collectBucket(sub, doc, this.numClusters - 1);
                if (val > this.clusterCentroids.get((long)bucketOrd)) {
                    ++bucketOrd;
                }
                this.moveLastCluster(bucketOrd);
                this.updateAvgBucketDistance();
            } else {
                this.addToCluster(bucketOrd, val);
                VariableWidthHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                if (bucketOrd == 0 || bucketOrd == this.numClusters - 1) {
                    this.updateAvgBucketDistance();
                }
            }
            return this;
        }

        private void updateAvgBucketDistance() {
            this.avgBucketDistance = (this.clusterCentroids.get((long)(this.numClusters - 1)) - this.clusterCentroids.get(0L)) / (double)(this.numClusters - 1);
        }

        private void createAndAppendNewCluster(double value) {
            this.clusterMaxes = VariableWidthHistogramAggregator.this.bigArrays.grow(this.clusterMaxes, (long)(this.numClusters + 1));
            this.clusterMins = VariableWidthHistogramAggregator.this.bigArrays.grow(this.clusterMins, (long)(this.numClusters + 1));
            this.clusterCentroids = VariableWidthHistogramAggregator.this.bigArrays.grow(this.clusterCentroids, (long)(this.numClusters + 1));
            this.clusterSizes = VariableWidthHistogramAggregator.this.bigArrays.grow(this.clusterSizes, (long)(this.numClusters + 1));
            this.clusterMaxes.set((long)this.numClusters, value);
            this.clusterMins.set((long)this.numClusters, value);
            this.clusterCentroids.set((long)this.numClusters, value);
            this.clusterSizes.set((long)this.numClusters, 1.0);
            ++this.numClusters;
        }

        private void moveLastCluster(final int index) {
            if (index != this.numClusters - 1) {
                double holdMax = this.clusterMaxes.get((long)(this.numClusters - 1));
                double holdMin = this.clusterMins.get((long)(this.numClusters - 1));
                double holdCentroid = this.clusterCentroids.get((long)(this.numClusters - 1));
                double holdSize = this.clusterSizes.get((long)(this.numClusters - 1));
                for (int i = this.numClusters - 1; i > index; --i) {
                    this.clusterMaxes.set((long)i, this.clusterMaxes.get((long)(i - 1)));
                    this.clusterMins.set((long)i, this.clusterMins.get((long)(i - 1)));
                    this.clusterCentroids.set((long)i, this.clusterCentroids.get((long)(i - 1)));
                    this.clusterSizes.set((long)i, this.clusterSizes.get((long)(i - 1)));
                }
                this.clusterMaxes.set((long)index, holdMax);
                this.clusterMins.set((long)index, holdMin);
                this.clusterCentroids.set((long)index, holdCentroid);
                this.clusterSizes.set((long)index, holdSize);
                LongUnaryOperator mergeMap = new LongUnaryOperator(){

                    @Override
                    public long applyAsLong(long i) {
                        if (i < (long)index) {
                            return i;
                        }
                        if (i == (long)(MergeBucketsPhase.this.numClusters - 1)) {
                            return index;
                        }
                        return i + 1L;
                    }
                };
                VariableWidthHistogramAggregator.this.mergeBuckets(this.numClusters, mergeMap);
                if (VariableWidthHistogramAggregator.this.deferringCollector != null) {
                    VariableWidthHistogramAggregator.this.deferringCollector.mergeBuckets(mergeMap);
                }
            }
        }

        private void addToCluster(int bucketOrd, double val) {
            assert (bucketOrd < this.numClusters);
            double max = Math.max(this.clusterMaxes.get((long)bucketOrd), val);
            double min = Math.min(this.clusterMins.get((long)bucketOrd), val);
            double oldCentroid = this.clusterCentroids.get((long)bucketOrd);
            double size = this.clusterSizes.get((long)bucketOrd);
            double newCentroid = (oldCentroid * size + val) / (size + 1.0);
            this.clusterMaxes.set((long)bucketOrd, max);
            this.clusterMins.set((long)bucketOrd, min);
            this.clusterCentroids.set((long)bucketOrd, newCentroid);
            this.clusterSizes.increment((long)bucketOrd, 1.0);
        }

        private int getNearestBucket(double value) {
            if (this.numClusters == 0) {
                return -1;
            }
            BigArrays.DoubleBinarySearcher binarySearcher = new BigArrays.DoubleBinarySearcher(this.clusterCentroids);
            return binarySearcher.search(0, this.numClusters - 1, value);
        }

        @Override
        int finalNumBuckets() {
            return this.numClusters;
        }

        @Override
        InternalVariableWidthHistogram.Bucket buildBucket(int bucketOrd, InternalAggregations subAggregations) {
            return new InternalVariableWidthHistogram.Bucket(this.clusterCentroids.get((long)bucketOrd), new InternalVariableWidthHistogram.Bucket.BucketBounds(this.clusterMins.get((long)bucketOrd), this.clusterMaxes.get((long)bucketOrd)), VariableWidthHistogramAggregator.this.bucketDocCount(bucketOrd), VariableWidthHistogramAggregator.this.formatter, subAggregations);
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.clusterMaxes, this.clusterMins, this.clusterCentroids, this.clusterSizes});
        }

        private class ClusterSorter
        extends InPlaceMergeSorter {
            final DoubleArray values;
            final long[] indexes;

            ClusterSorter(MergeBucketsPhase mergeBucketsPhase, DoubleArray values, int length) {
                this.values = values;
                this.indexes = new long[length];
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.indexes[i] = i;
                }
            }

            protected int compare(int i, int j) {
                double iVal = this.values.get(this.indexes[i]);
                double jVal = this.values.get(this.indexes[j]);
                return Double.compare(iVal, jVal);
            }

            protected void swap(int i, int j) {
                long hold = this.indexes[i];
                this.indexes[i] = this.indexes[j];
                this.indexes[j] = hold;
            }

            public long[] generateMergeMap() {
                this.sort(0, this.indexes.length);
                return this.indexes;
            }
        }
    }
}

