/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregatorSupplier;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class VariableWidthHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int numBuckets;
    private final int shardSize;
    private final int initialBuffer;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(VariableWidthHistogramAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.NUMERIC, VariableWidthHistogramAggregator::new, true);
    }

    VariableWidthHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, int shardSize, int initialBuffer, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.numBuckets = numBuckets;
        this.shardSize = shardSize;
        this.initialBuffer = initialBuffer;
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new IllegalArgumentException("[variable_width_histogram] cannot be nested inside an aggregation that collects more than a single bucket.");
        }
        return ((VariableWidthHistogramAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(VariableWidthHistogramAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new VariableWidthHistogramAggregator(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

