/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.nested;

import io.skylite.common.collect.Tuple;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.nested.InternalNested;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregator;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregatorFactory;

public class NestedAggregationBuilder
extends AbstractAggregationBuilder<NestedAggregationBuilder> {
    public static final String NAME = "nested";
    private final String path;

    public NestedAggregationBuilder(String name, String path) {
        super(name);
        if (path == null) {
            throw new IllegalArgumentException("[path] must not be null: [" + name + "]");
        }
        this.path = path;
    }

    protected NestedAggregationBuilder(NestedAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.path = clone.path;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new NestedAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public NestedAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.path = in.readString();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.path);
    }

    public String path() {
        return this.path;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ObjectMapper childObjectMapper = context.getObjectMapper(this.path);
        if (childObjectMapper == null) {
            return new NestedAggregatorFactory(this.name, null, null, context, parent, subFactoriesBuilder, this.metadata);
        }
        if (!childObjectMapper.isNested()) {
            throw new AggregationExecutionException("[nested] nested path [" + this.path + "] is not nested");
        }
        try {
            NestedObjectMapper parentObjectMapper = context.nestedScope().nextLevel((NestedObjectMapper)childObjectMapper);
            NestedAggregatorFactory nestedAggregatorFactory = new NestedAggregatorFactory(this.name, parentObjectMapper, (NestedObjectMapper)childObjectMapper, context, parent, subFactoriesBuilder, this.metadata);
            return nestedAggregatorFactory;
        }
        finally {
            context.nestedScope().previousLevel();
        }
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NestedAggregator.PATH_FIELD.getPreferredName(), this.path);
        builder.endObject();
        return builder;
    }

    public static NestedAggregationBuilder parse(XContentParser parser, String aggregationName) throws IOException {
        return NestedAggregationBuilder.parse(aggregationName, parser);
    }

    public static NestedAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String path = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (NestedAggregator.PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    path = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [" + aggregationName + "].", new Object[0]);
        }
        if (path == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [path] field for nested aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new NestedAggregationBuilder(aggregationName, path);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NestedAggregationBuilder other = (NestedAggregationBuilder)((Object)obj);
        return Objects.equals(this.path, other.path);
    }

    public String getType() {
        return NAME;
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return NestedAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return NestedAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalNested::new));
        }

        public ContextParser<String, NestedAggregationBuilder> getParser() {
            return NestedAggregationBuilder::parse;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

