/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.nested;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.bucket.nested.InternalNested;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregator;

public class NestedAggregatorFactory
extends AggregatorFactory {
    private final NestedObjectMapper parentObjectMapper;
    private final NestedObjectMapper childObjectMapper;

    NestedAggregatorFactory(String name, NestedObjectMapper parentObjectMapper, NestedObjectMapper childObjectMapper, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.parentObjectMapper = parentObjectMapper;
        this.childObjectMapper = childObjectMapper;
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (this.childObjectMapper == null) {
            return new Unmapped(this.name, searchContext, parent, this.factories, metadata);
        }
        return new NestedAggregator(this.name, this.factories, this.parentObjectMapper, this.childObjectMapper, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    private static final class Unmapped
    extends NonCollectingAggregator {
        Unmapped(String name, SearchExecutionContext context, Aggregator parent, AggregatorFactories factories, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
        }

        public InternalAggregation buildEmptyAggregation() {
            return new InternalNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
        }
    }
}

