/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.nested;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.opensearch.search.aggregations.bucket.nested.ReverseNestedAggregator;

public class ReverseNestedAggregatorFactory
extends AggregatorFactory {
    private final boolean unmapped;
    private final NestedObjectMapper parentObjectMapper;

    public ReverseNestedAggregatorFactory(String name, boolean unmapped, NestedObjectMapper parentObjectMapper, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.unmapped = unmapped;
        this.parentObjectMapper = parentObjectMapper;
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (this.unmapped) {
            return new Unmapped(this.name, searchContext, parent, this.factories, metadata);
        }
        return new ReverseNestedAggregator(this.name, this.factories, this.parentObjectMapper, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    private static final class Unmapped
    extends NonCollectingAggregator {
        Unmapped(String name, SearchExecutionContext context, Aggregator parent, AggregatorFactories factories, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
        }

        public InternalAggregation buildEmptyAggregation() {
            return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
        }
    }
}

