/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.bucket.range.BinaryRangeAggregator;
import org.opensearch.search.aggregations.bucket.range.IpRangeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.range.IpRangeAggregatorSupplier;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class BinaryRangeAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final List<BinaryRangeAggregator.Range> ranges;
    private final boolean keyed;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(IpRangeAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.IP, BinaryRangeAggregator::new, true);
    }

    public BinaryRangeAggregatorFactory(String name, ValuesSourceConfig config, List<BinaryRangeAggregator.Range> ranges, boolean keyed, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.ranges = ranges;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new BinaryRangeAggregator(this.name, this.factories, null, this.config.format(), this.ranges, this.keyed, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((IpRangeAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(IpRangeAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.factories, this.config.getValuesSource(), this.config.format(), this.ranges, this.keyed, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

