/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.geo.GeoDistance;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.range.GeoDistanceAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.range.GeoDistanceRangeAggregatorFactory;
import org.opensearch.search.aggregations.bucket.range.InternalGeoDistance;
import org.opensearch.search.aggregations.bucket.range.InternalRange;
import org.opensearch.search.aggregations.bucket.range.RangeAggregator;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class GeoDistanceAggregationBuilder
extends ValuesSourceAggregationBuilder<GeoDistanceAggregationBuilder> {
    public static final String NAME = "geo_distance";
    public static final AggregationRegistry.RegistryKey<GeoDistanceAggregatorSupplier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("geo_distance", GeoDistanceAggregatorSupplier.class);
    static final ParseField ORIGIN_FIELD = new ParseField("origin", new String[]{"center", "point", "por"});
    static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ObjectParser<GeoDistanceAggregationBuilder, Void> PARSER = new ObjectParser("geo_distance");
    private GeoPoint origin;
    private List<Range> ranges = new ArrayList<Range>();
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private GeoDistance distanceType = GeoDistance.ARC;
    private boolean keyed = false;

    public static GeoDistanceAggregationBuilder parse(XContentParser parser, String aggregationName) throws IOException {
        GeoDistanceAggregationBuilder builder = (GeoDistanceAggregationBuilder)((Object)PARSER.parse(parser, (Object)new GeoDistanceAggregationBuilder(aggregationName), null));
        if (builder.origin() == null) {
            throw new IllegalArgumentException("Aggregation [" + aggregationName + "] must define an [origin].");
        }
        return builder;
    }

    private static GeoPoint parseGeoPoint(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            GeoPoint point = new GeoPoint();
            point.resetFromString(parser.text());
            return point;
        }
        if (token == XContentParser.Token.START_ARRAY) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (Double.isNaN(lon)) {
                    lon = parser.doubleValue();
                    continue;
                }
                if (Double.isNaN(lat)) {
                    lat = parser.doubleValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "malformed [" + ORIGIN_FIELD.getPreferredName() + "]: a geo point array must be of the form [lon, lat]", new Object[0]);
            }
            return new GeoPoint(lat, lon);
        }
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("lat".equals(currentFieldName)) {
                    lat = parser.doubleValue();
                    continue;
                }
                if (!"lon".equals(currentFieldName)) continue;
                lon = parser.doubleValue();
            }
            if (Double.isNaN(lat) || Double.isNaN(lon)) {
                throw new ParsingException(parser.getTokenLocation(), "malformed [" + currentFieldName + "] geo point object. either [lat] or [lon] (or both) are missing", new Object[0]);
            }
            return new GeoPoint(lat, lon);
        }
        throw new IllegalArgumentException("Unexpected token [" + String.valueOf(token) + "] while parsing geo point");
    }

    private static Range parseRange(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fromAsStr = null;
        String toAsStr = null;
        double from = 0.0;
        double to = Double.POSITIVE_INFINITY;
        String key = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (RangeAggregator.Range.FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    from = parser.doubleValue();
                    continue;
                }
                if (RangeAggregator.Range.TO_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    to = parser.doubleValue();
                    continue;
                }
                XContentParserUtils.throwUnknownField((String)currentFieldName, (XContentLocation)parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (RangeAggregator.Range.KEY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    key = parser.text();
                    continue;
                }
                if (RangeAggregator.Range.FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fromAsStr = parser.text();
                    continue;
                }
                if (RangeAggregator.Range.TO_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    toAsStr = parser.text();
                    continue;
                }
                XContentParserUtils.throwUnknownField((String)currentFieldName, (XContentLocation)parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if (RangeAggregator.Range.FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler()) || RangeAggregator.Range.TO_FIELD.match(currentFieldName, parser.getDeprecationHandler()) || RangeAggregator.Range.KEY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
                XContentParserUtils.throwUnknownField((String)currentFieldName, (XContentLocation)parser.getTokenLocation());
                continue;
            }
            XContentParserUtils.throwUnknownToken((XContentParser.Token)token, (XContentLocation)parser.getTokenLocation());
        }
        if (fromAsStr != null || toAsStr != null) {
            return new Range(key, Double.parseDouble(fromAsStr), Double.parseDouble(toAsStr));
        }
        return new Range(key, from, to);
    }

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        GeoDistanceRangeAggregatorFactory.registerAggregators(builder);
    }

    public GeoDistanceAggregationBuilder(String name, GeoPoint origin) {
        this(name, origin, InternalGeoDistance.FACTORY);
        if (origin == null) {
            throw new IllegalArgumentException("[origin] must not be null: [" + name + "]");
        }
    }

    private GeoDistanceAggregationBuilder(String name, GeoPoint origin, InternalRange.Factory<InternalGeoDistance.Bucket, InternalGeoDistance> rangeFactory) {
        super(name);
        this.origin = origin;
    }

    public GeoDistanceAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.origin = new GeoPoint(in.readDouble(), in.readDouble());
        int size = in.readVInt();
        this.ranges = new ArrayList<Range>(size);
        for (int i = 0; i < size; ++i) {
            this.ranges.add(new Range(in));
        }
        this.keyed = in.readBoolean();
        this.distanceType = GeoDistance.readFromStream((StreamInput)in);
        this.unit = DistanceUnit.readFromStream((StreamInput)in);
    }

    GeoDistanceAggregationBuilder(String name) {
        this(name, null, InternalGeoDistance.FACTORY);
    }

    protected GeoDistanceAggregationBuilder(GeoDistanceAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.origin = clone.origin;
        this.distanceType = clone.distanceType;
        this.unit = clone.unit;
        this.keyed = clone.keyed;
        this.ranges = new ArrayList<Range>(clone.ranges);
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return GeoValuesSourceType.GEOPOINT;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new GeoDistanceAggregationBuilder(this, factoriesBuilder, metadata);
    }

    GeoDistanceAggregationBuilder origin(GeoPoint origin) {
        this.origin = origin;
        return this;
    }

    public GeoPoint origin() {
        return this.origin;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.origin.lat());
        out.writeDouble(this.origin.lon());
        out.writeVInt(this.ranges.size());
        for (Range range : this.ranges) {
            range.writeTo(out);
        }
        out.writeBoolean(this.keyed);
        this.distanceType.writeTo(out);
        this.unit.writeTo(out);
    }

    public GeoDistanceAggregationBuilder addRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("[range] must not be null: [" + this.name + "]");
        }
        this.ranges.add(range);
        return this;
    }

    public GeoDistanceAggregationBuilder addRange(String key, double from, double to) {
        this.ranges.add(new Range(key, from, to));
        return this;
    }

    public GeoDistanceAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public GeoDistanceAggregationBuilder addUnboundedTo(String key, double to) {
        this.ranges.add(new Range(key, null, to));
        return this;
    }

    public GeoDistanceAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public GeoDistanceAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new Range(key, from, null));
        return this;
    }

    public GeoDistanceAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    public List<Range> range() {
        return this.ranges;
    }

    public String getType() {
        return NAME;
    }

    @Override
    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    public GeoDistanceAggregationBuilder unit(DistanceUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("[unit] must not be null: [" + this.name + "]");
        }
        this.unit = unit;
        return this;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    public GeoDistanceAggregationBuilder distanceType(GeoDistance distanceType) {
        if (distanceType == null) {
            throw new IllegalArgumentException("[distanceType] must not be null: [" + this.name + "]");
        }
        this.distanceType = distanceType;
        return this;
    }

    public GeoDistance distanceType() {
        return this.distanceType;
    }

    public GeoDistanceAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Range[] ranges = this.ranges.toArray(new Range[this.range().size()]);
        if (ranges.length == 0) {
            throw new IllegalArgumentException("No [ranges] specified for the [" + this.getName() + "] aggregation");
        }
        return new GeoDistanceRangeAggregatorFactory(this.name, config, this.origin, ranges, this.unit, this.distanceType, this.keyed, context, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ORIGIN_FIELD.getPreferredName(), (ToXContent)this.origin);
        builder.field(RangeAggregator.RANGES_FIELD.getPreferredName(), this.ranges);
        builder.field(RangeAggregator.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(UNIT_FIELD.getPreferredName(), (Object)this.unit);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), (Object)this.distanceType);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.origin, this.ranges, this.keyed, this.distanceType, this.unit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoDistanceAggregationBuilder other = (GeoDistanceAggregationBuilder)((Object)obj);
        return Objects.equals(this.origin, other.origin) && Objects.equals(this.ranges, other.ranges) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.distanceType, other.distanceType) && Objects.equals(this.unit, other.unit);
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, false, false);
        PARSER.declareBoolean(GeoDistanceAggregationBuilder::keyed, RangeAggregator.KEYED_FIELD);
        PARSER.declareObjectArray((agg, ranges) -> {
            for (Range range : ranges) {
                agg.addRange(range);
            }
        }, (p, c) -> GeoDistanceAggregationBuilder.parseRange(p), RangeAggregator.RANGES_FIELD);
        PARSER.declareField(GeoDistanceAggregationBuilder::unit, p -> DistanceUnit.fromString((String)p.text()), UNIT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(GeoDistanceAggregationBuilder::distanceType, p -> GeoDistance.fromString((String)p.text()), DISTANCE_TYPE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(GeoDistanceAggregationBuilder::origin, GeoDistanceAggregationBuilder::parseGeoPoint, ORIGIN_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
    }

    public static class Range
    extends RangeAggregator.Range {
        public Range(String key, Double from, Double to) {
            super(Range.key(key, from, to), from == null ? 0.0 : from, to);
        }

        public Range(StreamInput in) throws IOException {
            super(in.readOptionalString(), in.readDouble(), in.readDouble());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeDouble(this.from);
            out.writeDouble(this.to);
        }

        private static String key(String key, Double from, Double to) {
            if (key != null) {
                return key;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(from == null || from == 0.0 ? "*" : from);
            sb.append("-");
            sb.append(to == null || Double.isInfinite(to) ? "*" : to);
            return sb.toString();
        }
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return GeoDistanceAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return GeoDistanceAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalGeoDistance::new));
        }

        public ContextParser<String, GeoDistanceAggregationBuilder> getParser() {
            return GeoDistanceAggregationBuilder::parse;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return GeoDistanceAggregationBuilder::registerAggregators;
        }
    }
}

