/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.geo.GeoDistance;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoUtils;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.index.fielddata.geo.MultiGeoPointValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.search.aggregations.bucket.range.GeoDistanceAggregationBuilder;
import org.opensearch.search.aggregations.bucket.range.GeoDistanceAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.range.InternalGeoDistance;
import org.opensearch.search.aggregations.bucket.range.InternalRange;
import org.opensearch.search.aggregations.bucket.range.RangeAggregator;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class GeoDistanceRangeAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final InternalRange.Factory<InternalGeoDistance.Bucket, InternalGeoDistance> rangeFactory = InternalGeoDistance.FACTORY;
    private final GeoPoint origin;
    private final GeoDistanceAggregationBuilder.Range[] ranges;
    private final DistanceUnit unit;
    private final GeoDistance distanceType;
    private final boolean keyed;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(GeoDistanceAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoValuesSourceType.GEOPOINT, (name, factories, distanceType, origin, units, valuesSource, format, rangeFactory, ranges, keyed, context, parent, cardinality, metadata) -> {
            DistanceSource distanceSource = new DistanceSource((GeoPointValuesSource)valuesSource, distanceType, origin, units);
            return new RangeAggregator(name, factories, distanceSource, format, rangeFactory, ranges, keyed, context, parent, cardinality, metadata);
        }, true);
    }

    public GeoDistanceRangeAggregatorFactory(String name, ValuesSourceConfig config, GeoPoint origin, GeoDistanceAggregationBuilder.Range[] ranges, DistanceUnit unit, GeoDistance distanceType, boolean keyed, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.origin = origin;
        this.ranges = ranges;
        this.unit = unit;
        this.distanceType = distanceType;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new RangeAggregator.Unmapped(this.name, this.factories, (RangeAggregator.Range[])this.ranges, this.keyed, this.config.format(), searchContext, parent, this.rangeFactory, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((GeoDistanceAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(GeoDistanceAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.factories, this.distanceType, this.origin, this.unit, this.config.getValuesSource(), this.config.format(), this.rangeFactory, this.ranges, this.keyed, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    private static class DistanceSource
    extends NumericValuesSource {
        private final GeoPointValuesSource source;
        private final GeoDistance distanceType;
        private final DistanceUnit units;
        private final GeoPoint origin;

        DistanceSource(GeoPointValuesSource source, GeoDistance distanceType, GeoPoint origin, DistanceUnit units) {
            this.source = source;
            this.distanceType = distanceType;
            this.units = units;
            this.origin = origin;
        }

        public boolean isFloatingPoint() {
            return true;
        }

        public boolean isBigInteger() {
            return false;
        }

        public SortedNumericDocValues longValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }

        public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
            MultiGeoPointValues geoValues = this.source.geoPointValues(ctx);
            return GeoUtils.distanceValues((GeoDistance)this.distanceType, (DistanceUnit)this.units, (MultiGeoPointValues)geoValues, (GeoPoint[])new GeoPoint[]{this.origin});
        }

        public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }
    }
}

