/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.LongTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.UnsignedLongTerms;

public class DoubleTerms
extends InternalMappedTerms<DoubleTerms, Bucket> {
    public static final String NAME = "dterms";

    public DoubleTerms(String name, BucketOrder reduceOrder, BucketOrder order, Map<String, Object> metadata, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError, TermsAggregator.BucketCountThresholds bucketCountThresholds) {
        super(name, reduceOrder, order, metadata, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError, bucketCountThresholds);
    }

    public DoubleTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public DoubleTerms create(List<Bucket> buckets) {
        return new DoubleTerms(this.name, this.reduceOrder, this.order, (Map<String, Object>)this.metadata, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError, this.bucketCountThresholds);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    protected DoubleTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new DoubleTerms(name, reduceOrder, this.order, (Map<String, Object>)this.getMetadata(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError, this.bucketCountThresholds);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        boolean promoteToDouble = false;
        for (InternalAggregation agg : aggregations) {
            if (agg instanceof LongTerms && (((LongTerms)agg).format == DocValueFormat.RAW || ((LongTerms)agg).format == DocValueFormat.UNSIGNED_LONG_SHIFTED)) {
                promoteToDouble = true;
                break;
            }
            if (!(agg instanceof UnsignedLongTerms) || ((UnsignedLongTerms)agg).format != DocValueFormat.RAW && ((UnsignedLongTerms)agg).format != DocValueFormat.UNSIGNED_LONG_SHIFTED && ((UnsignedLongTerms)agg).format != DocValueFormat.UNSIGNED_LONG) continue;
            promoteToDouble = true;
            break;
        }
        if (!promoteToDouble) {
            return super.reduce(aggregations, reduceContext);
        }
        ArrayList<InternalAggregation> newAggs = new ArrayList<InternalAggregation>(aggregations.size());
        for (InternalAggregation agg : aggregations) {
            DoubleTerms dTerms;
            if (agg instanceof LongTerms) {
                dTerms = LongTerms.convertLongTermsToDouble((LongTerms)agg, this.format);
                newAggs.add(dTerms);
                continue;
            }
            if (agg instanceof UnsignedLongTerms) {
                dTerms = UnsignedLongTerms.convertUnsignedLongTermsToDouble((UnsignedLongTerms)agg, this.format);
                newAggs.add(dTerms);
                continue;
            }
            newAggs.add(agg);
        }
        return ((InternalAggregation)newAggs.get(0)).reduce(newAggs, reduceContext);
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.term, docCount, aggs, prototype.showDocCountError, docCountError, this.format);
    }

    static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        double term;

        Bucket(double term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.term = term;
        }

        Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.term = in.readDouble();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeDouble(this.term);
        }

        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        public Object getKey() {
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        public int compareKey(Bucket other) {
            return Double.compare(this.term, other.term);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term).toString());
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

