/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.Aggregations;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.aggregations.KeyComparable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;

public class InternalMultiTerms
extends InternalTerms<InternalMultiTerms, Bucket> {
    private final int shardSize;
    private final boolean showTermDocCountError;
    private final long otherDocCount;
    private final List<DocValueFormat> termFormats;
    private final List<Bucket> buckets;
    private Map<String, Bucket> bucketMap;
    private long docCountError;

    public InternalMultiTerms(String name, BucketOrder reduceOrder, BucketOrder order, Map<String, Object> metadata, int shardSize, boolean showTermDocCountError, long otherDocCount, long docCountError, List<DocValueFormat> formats, List<Bucket> buckets, TermsAggregator.BucketCountThresholds bucketCountThresholds) {
        super(name, reduceOrder, order, bucketCountThresholds, metadata);
        this.shardSize = shardSize;
        this.showTermDocCountError = showTermDocCountError;
        this.otherDocCount = otherDocCount;
        this.termFormats = formats;
        this.buckets = buckets;
        this.docCountError = docCountError;
    }

    public InternalMultiTerms(StreamInput in) throws IOException {
        super(in);
        this.docCountError = in.readZLong();
        this.termFormats = in.readList(stream -> (DocValueFormat)stream.readNamedWriteable(DocValueFormat.class));
        this.shardSize = InternalMultiTerms.readSize((StreamInput)in);
        this.showTermDocCountError = in.readBoolean();
        this.otherDocCount = in.readVLong();
        this.buckets = in.readList(steam -> new Bucket(steam, this.termFormats, this.showTermDocCountError));
    }

    public String getWriteableName() {
        return "multi_terms";
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return InternalMultiTerms.doXContentCommon(builder, params, this.docCountError, this.otherDocCount, this.buckets);
    }

    @Override
    public InternalMultiTerms create(List<Bucket> buckets) {
        return new InternalMultiTerms(this.name, this.reduceOrder, this.order, this.metadata, this.shardSize, this.showTermDocCountError, this.otherDocCount, this.docCountError, this.termFormats, buckets, this.bucketCountThresholds);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termValues, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.termFormats);
    }

    @Override
    protected void writeTermTypeInfoTo(StreamOutput out) throws IOException {
        out.writeZLong(this.docCountError);
        out.writeCollection(this.termFormats, StreamOutput::writeNamedWriteable);
        InternalMultiTerms.writeSize((int)this.shardSize, (StreamOutput)out);
        out.writeBoolean(this.showTermDocCountError);
        out.writeVLong(this.otherDocCount);
        out.writeList(this.buckets);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public Bucket getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = this.buckets.stream().collect(Collectors.toMap(Bucket::getKeyAsString, Function.identity()));
        }
        return this.bucketMap.get(term);
    }

    @Override
    public long getDocCountError() {
        return this.docCountError;
    }

    @Override
    public long getSumOfOtherDocCounts() {
        return this.otherDocCount;
    }

    @Override
    protected void setDocCountError(long docCountError) {
        this.docCountError = docCountError;
    }

    @Override
    protected int getShardSize() {
        return this.shardSize;
    }

    @Override
    protected InternalMultiTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new InternalMultiTerms(name, reduceOrder, this.order, this.metadata, this.shardSize, this.showTermDocCountError, otherDocCount, docCountError, this.termFormats, buckets, this.bucketCountThresholds);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.termValues, docCount, aggs, prototype.showDocCountError, prototype.docCountError, prototype.termFormats);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMultiTerms that = (InternalMultiTerms)obj;
        if (this.showTermDocCountError && this.docCountError != that.docCountError) {
            return false;
        }
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.otherDocCount, that.otherDocCount) && Objects.equals(this.showTermDocCountError, that.showTermDocCountError) && Objects.equals(this.shardSize, that.shardSize) && Objects.equals(this.docCountError, that.docCountError);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.otherDocCount, this.showTermDocCountError, this.shardSize);
    }

    static Object formatObject(Object obj, DocValueFormat format) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == BytesRef.class) {
            BytesRef value = (BytesRef)obj;
            if (format == DocValueFormat.RAW) {
                return value.utf8ToString();
            }
            return format.format(value);
        }
        if (obj.getClass() == Long.class) {
            long value = (Long)obj;
            if (format == DocValueFormat.RAW) {
                return value;
            }
            return format.format(value);
        }
        if (obj.getClass() == Double.class) {
            double value = (Double)obj;
            if (format == DocValueFormat.RAW) {
                return value;
            }
            return format.format(value);
        }
        return obj;
    }

    public static class Bucket
    extends InternalTerms.AbstractInternalBucket
    implements KeyComparable<Bucket> {
        protected long bucketOrd;
        protected List<Object> termValues;
        protected long docCount;
        protected InternalAggregations aggregations;
        protected boolean showDocCountError;
        protected long docCountError;
        protected final List<DocValueFormat> termFormats;
        private static final String PIPE = "|";

        public static Bucket EMPTY(boolean showTermDocCountError, List<DocValueFormat> formats) {
            return new Bucket(null, 0L, null, showTermDocCountError, 0L, formats);
        }

        public Bucket(List<Object> values, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, List<DocValueFormat> formats) {
            this.termValues = values;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.showDocCountError = showDocCountError;
            this.docCountError = docCountError;
            this.termFormats = formats;
        }

        public Bucket(StreamInput in, List<DocValueFormat> formats, boolean showDocCountError) throws IOException {
            this.termValues = in.readList(StreamInput::readGenericValue);
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
            this.showDocCountError = showDocCountError;
            this.docCountError = -1L;
            if (showDocCountError) {
                this.docCountError = in.readLong();
            }
            this.termFormats = formats;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), (Iterable)this.getKey());
            builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            if (this.showDocCountError) {
                builder.field(InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), this.getDocCountError());
            }
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.termValues, StreamOutput::writeGenericValue);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
            if (this.showDocCountError) {
                out.writeLong(this.docCountError);
            }
        }

        public List<Object> getKey() {
            ArrayList<Object> keys = new ArrayList<Object>(this.termValues.size());
            for (int i = 0; i < this.termValues.size(); ++i) {
                keys.add(InternalMultiTerms.formatObject(this.termValues.get(i), this.termFormats.get(i)));
            }
            return keys;
        }

        public String getKeyAsString() {
            return this.getKey().stream().map(Object::toString).collect(Collectors.joining(PIPE));
        }

        public long getDocCount() {
            return this.docCount;
        }

        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        void setDocCountError(long docCountError) {
            this.docCountError = docCountError;
        }

        @Override
        public void setDocCountError(Function<Long, Long> updater) {
            this.docCountError = updater.apply(this.docCountError);
        }

        @Override
        public boolean showDocCountError() {
            return this.showDocCountError;
        }

        @Override
        public Number getKeyAsNumber() {
            throw new IllegalArgumentException("getKeyAsNumber is not supported by [multi_terms]");
        }

        @Override
        public long getDocCountError() {
            if (!this.showDocCountError) {
                throw new IllegalStateException("show_terms_doc_count_error is false");
            }
            return this.docCountError;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bucket other = (Bucket)obj;
            if (this.showDocCountError && this.docCountError != other.docCountError) {
                return false;
            }
            return this.termValues.equals(other.termValues) && this.docCount == other.docCount && this.aggregations.equals((Object)other.aggregations) && this.showDocCountError == other.showDocCountError;
        }

        public int hashCode() {
            return Objects.hash(this.termValues, this.docCount, this.aggregations, this.showDocCountError, this.showDocCountError ? this.docCountError : 0L);
        }

        public int compareKey(Bucket other) {
            return new BucketComparator().compare(this.termValues, other.termValues);
        }

        protected static class BucketComparator
        implements Comparator<List<Object>> {
            protected BucketComparator() {
            }

            @Override
            public int compare(List<Object> thisObjects, List<Object> thatObjects) {
                if (thisObjects.size() != thatObjects.size()) {
                    throw new AggregationExecutionException("[multi_terms] aggregations failed due to terms size is different");
                }
                for (int i = 0; i < thisObjects.size(); ++i) {
                    Object thatObject;
                    Object thisObject = thisObjects.get(i);
                    int ret = ((Comparable)thisObject).compareTo(thatObject = thatObjects.get(i));
                    if (ret == 0) continue;
                    return ret;
                }
                return 0;
            }
        }
    }
}

