/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.common.collect.Tuple;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalOrder;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.script.Script;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.search.aggregations.bucket.BucketUtils;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.support.MultiTermsValuesSourceConfig;

public class MultiTermsAggregationFactory
extends AggregatorFactory {
    private final List<Tuple<ValuesSourceConfig, IncludeExclude>> configs;
    private final List<DocValueFormat> formats;
    private final BucketOrder order;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(MultiTermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), config -> {
            IncludeExclude.StringFilter filter = config.v2() == null ? null : ((IncludeExclude)config.v2()).convertToStringFilter(((ValuesSourceConfig)config.v1()).format());
            return MultiTermsAggregator.InternalValuesSourceFactory.bytesValuesSource(((ValuesSourceConfig)config.v1()).getValuesSource(), filter);
        }, true);
        builder.register(MultiTermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.DATE), config -> {
            ValuesSourceConfig valuesSourceConfig = (ValuesSourceConfig)config.v1();
            IncludeExclude includeExclude = (IncludeExclude)config.v2();
            NumericValuesSource valuesSource = (NumericValuesSource)valuesSourceConfig.getValuesSource();
            IncludeExclude.LongFilter longFilter = null;
            if (valuesSource.isFloatingPoint()) {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToDoubleFilter();
                }
                return MultiTermsAggregator.InternalValuesSourceFactory.doubleValueSource(valuesSource, longFilter);
            }
            if (valuesSource.isBigInteger()) {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToDoubleFilter();
                }
                return MultiTermsAggregator.InternalValuesSourceFactory.unsignedLongValuesSource(valuesSource, longFilter);
            }
            if (includeExclude != null) {
                longFilter = includeExclude.convertToLongFilter(valuesSourceConfig.format());
            }
            return MultiTermsAggregator.InternalValuesSourceFactory.longValuesSource(valuesSource, longFilter);
        }, true);
        builder.registerUsage("multi_terms");
    }

    public MultiTermsAggregationFactory(String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, List<MultiTermsValuesSourceConfig> multiTermConfigs, BucketOrder order, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, boolean showTermDocCountError) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.configs = multiTermConfigs.stream().map(c -> new Tuple((Object)ValuesSourceConfig.resolveUnregistered((AggregationContext)context, (ValueType)c.getUserValueTypeHint(), (String)c.getFieldName(), (Script)c.getScript(), (Object)c.getMissing(), (ZoneId)c.getTimeZone(), (String)c.getFormat(), (ValuesSourceType)CoreValuesSourceType.BYTES), (Object)c.getIncludeExclude())).collect(Collectors.toList());
        this.formats = this.configs.stream().map(c -> ((ValuesSourceConfig)c.v1()).format()).collect(Collectors.toList());
        this.order = order;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
        this.showTermDocCountError = showTermDocCountError;
    }

    protected Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (!InternalOrder.isKeyOrder((BucketOrder)this.order) && bucketCountThresholds.getShardSize() == TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        bucketCountThresholds.ensureValidity();
        return new MultiTermsAggregator(this.name, this.factories, this.showTermDocCountError, this.configs.stream().map(config -> ((InternalValuesSourceSupplier)this.context.getAggregationRegistry().getAggregator(MultiTermsAggregationBuilder.REGISTRY_KEY, (ValuesSourceConfig)config.v1())).build((Tuple<ValuesSourceConfig, IncludeExclude>)config)).collect(Collectors.toList()), this.configs.stream().map(c -> ((ValuesSourceConfig)c.v1()).format()).collect(Collectors.toList()), this.order, this.collectMode, bucketCountThresholds, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    public static interface InternalValuesSourceSupplier {
        public MultiTermsAggregator.InternalValuesSource build(Tuple<ValuesSourceConfig, IncludeExclude> var1);
    }
}

