/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.Version;
import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.LongRareTerms;
import org.opensearch.search.aggregations.bucket.terms.RareTermsAggregatorFactory;
import org.opensearch.search.aggregations.bucket.terms.RareTermsAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.terms.StringRareTerms;
import org.opensearch.search.aggregations.bucket.terms.UnmappedRareTerms;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class RareTermsAggregationBuilder
extends ValuesSourceAggregationBuilder<RareTermsAggregationBuilder> {
    public static final String NAME = "rare_terms";
    public static final AggregationRegistry.RegistryKey<RareTermsAggregatorSupplier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("rare_terms", RareTermsAggregatorSupplier.class);
    private static final ParseField MAX_DOC_COUNT_FIELD_NAME = new ParseField("max_doc_count", new String[0]);
    private static final ParseField PRECISION = new ParseField("precision", new String[0]);
    private static final int MAX_MAX_DOC_COUNT = 100;
    public static final ObjectParser<RareTermsAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"rare_terms", RareTermsAggregationBuilder::new);
    private IncludeExclude includeExclude = null;
    private int maxDocCount = 1;
    private double precision = 0.001;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        RareTermsAggregatorFactory.registerAggregators(builder);
    }

    public RareTermsAggregationBuilder(String name) {
        super(name);
    }

    private RareTermsAggregationBuilder(RareTermsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.includeExclude = clone.includeExclude;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new RareTermsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public RareTermsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.includeExclude = (IncludeExclude)in.readOptionalWriteable(IncludeExclude::new);
        this.maxDocCount = in.readVInt();
    }

    @Override
    protected boolean serializeTargetValueType(Version version) {
        return true;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.includeExclude);
        out.writeVInt(this.maxDocCount);
    }

    public RareTermsAggregationBuilder maxDocCount(long maxDocCount) {
        if (maxDocCount <= 0L) {
            throw new IllegalArgumentException("[" + MAX_DOC_COUNT_FIELD_NAME.getPreferredName() + "] must be greater than 0. Found [" + maxDocCount + "] in [" + this.name + "]");
        }
        if (maxDocCount > 100L) {
            throw new IllegalArgumentException("[" + MAX_DOC_COUNT_FIELD_NAME.getPreferredName() + "] must be smallerthan 100in [" + this.name + "]");
        }
        this.maxDocCount = (int)maxDocCount;
        return this;
    }

    public RareTermsAggregationBuilder includeExclude(IncludeExclude includeExclude) {
        this.includeExclude = includeExclude;
        return this;
    }

    public IncludeExclude includeExclude() {
        return this.includeExclude;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        if (precision < 1.0E-5) {
            throw new IllegalArgumentException("[precision] must be greater than 0.00001");
        }
        this.precision = precision;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new RareTermsAggregatorFactory(this.name, config, this.includeExclude, context, parent, subFactoriesBuilder, this.metadata, this.maxDocCount, this.precision);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.includeExclude != null) {
            this.includeExclude.toXContent(builder, params);
        }
        builder.field(MAX_DOC_COUNT_FIELD_NAME.getPreferredName(), this.maxDocCount);
        builder.field(PRECISION.getPreferredName(), this.precision);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.includeExclude, this.maxDocCount, this.precision);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RareTermsAggregationBuilder other = (RareTermsAggregationBuilder)((Object)obj);
        return Objects.equals(this.includeExclude, other.includeExclude) && Objects.equals(this.maxDocCount, other.maxDocCount) && Objects.equals(this.precision, other.precision);
    }

    public String getType() {
        return NAME;
    }

    @Override
    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, false);
        PARSER.declareLong(RareTermsAggregationBuilder::maxDocCount, MAX_DOC_COUNT_FIELD_NAME);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(v, b.includeExclude())), IncludeExclude::parseInclude, IncludeExclude.INCLUDE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(b.includeExclude(), v)), IncludeExclude::parseExclude, IncludeExclude.EXCLUDE_FIELD, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareDouble(RareTermsAggregationBuilder::setPrecision, PRECISION);
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return RareTermsAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return RareTermsAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Arrays.asList(new Tuple(Optional.of("srareterms"), StringRareTerms::new), new Tuple(Optional.of("umrareterms"), UnmappedRareTerms::new), new Tuple(Optional.of("lrareterms"), LongRareTerms::new));
        }

        public ObjectParser getParser() {
            return PARSER;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return RareTermsAggregationBuilder::registerAggregators;
        }
    }
}

