/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.bucket.BucketUtils;
import org.opensearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.MapStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.NumericTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.opensearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.SignificantTermsAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.UnmappedSignificantTerms;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class SignificantTermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SignificantTermsAggregatorFactory.class);
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final QueryBuilder backgroundFilter;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;

    static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(SignificantTermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), (Object)SignificantTermsAggregatorFactory.bytesSupplier(), true);
        builder.register(SignificantTermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), (Object)SignificantTermsAggregatorFactory.numericSupplier(), true);
    }

    private static SignificantTermsAggregatorSupplier bytesSupplier() {
        return new SignificantTermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchExecutionContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                ExecutionMode execution = null;
                if (executionHint != null) {
                    execution = ExecutionMode.fromString(executionHint, deprecationLogger);
                }
                if (!(valuesSource instanceof BytesValuesSource.WithOrdinals)) {
                    execution = ExecutionMode.MAP;
                }
                if (execution == null) {
                    execution = ExecutionMode.GLOBAL_ORDINALS;
                }
                if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                    throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
                }
                return execution.create(name, factories, valuesSource, format, bucketCountThresholds, includeExclude, context, parent, significanceHeuristic, lookup, cardinality, metadata);
            }
        };
    }

    private static SignificantTermsAggregatorSupplier numericSupplier() {
        return (name, factories, valuesSource, format, bucketCountThresholds, includeExclude, executionHint, context, parent, significanceHeuristic, lookup, cardinality, metadata) -> {
            if (includeExclude != null && includeExclude.isRegexBased()) {
                throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
            }
            NumericValuesSource numericValuesSource = (NumericValuesSource)valuesSource;
            if (numericValuesSource.isFloatingPoint()) {
                throw new UnsupportedOperationException("No support for examining floating point numerics");
            }
            IncludeExclude.LongFilter longFilter = null;
            if (includeExclude != null) {
                longFilter = includeExclude.convertToLongFilter(format);
            }
            return new NumericTermsAggregator(name, factories, agg -> {
                NumericTermsAggregator numericTermsAggregator = agg;
                Objects.requireNonNull(numericTermsAggregator);
                return numericTermsAggregator.new NumericTermsAggregator.SignificantLongTermsResults(lookup, significanceHeuristic, cardinality);
            }, numericValuesSource, format, null, bucketCountThresholds, context, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, longFilter, cardinality, metadata);
        };
    }

    SignificantTermsAggregatorFactory(String name, ValuesSourceConfig config, IncludeExclude includeExclude, String executionHint, QueryBuilder backgroundFilter, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        if (config.hasValues() && !config.fieldContext().fieldType().isSearchable()) {
            throw new IllegalArgumentException("SignificantText aggregation requires fields to be searchable, but [" + config.fieldContext().fieldType().name() + "] is not");
        }
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.backgroundFilter = backgroundFilter;
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds, metadata);
        return new NonCollectingAggregator(this, this.name, searchContext, parent, this.factories, metadata){

            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        SignificantTermsAggregatorSupplier aggregatorSupplier = (SignificantTermsAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(SignificantTermsAggregationBuilder.REGISTRY_KEY, this.config);
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        SignificanceLookup lookup = new SignificanceLookup(this.context, this.config.fieldContext().fieldType(), this.config.format(), this.backgroundFilter);
        return aggregatorSupplier.build(this.name, this.factories, this.config.getValuesSource(), this.config.format(), bucketCountThresholds, this.includeExclude, this.executionHint, searchContext, parent, this.significanceHeuristic, lookup, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchExecutionContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                int maxRegexLength = aggregationContext.getQueryShardContext().getIndexSettings().getMaxRegexLength();
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format, maxRegexLength);
                return new MapStringTermsAggregator(name, factories, new MapStringTermsAggregator.ValuesSourceCollectorSource(valuesSource), a -> {
                    MapStringTermsAggregator mapStringTermsAggregator = a;
                    Objects.requireNonNull(mapStringTermsAggregator);
                    return mapStringTermsAggregator.new MapStringTermsAggregator.SignificantTermsResults(lookup, significanceHeuristic, cardinality);
                }, null, format, bucketCountThresholds, filter, aggregationContext, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, cardinality, metadata);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchExecutionContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                int maxRegexLength = aggregationContext.getQueryShardContext().getIndexSettings().getMaxRegexLength();
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format, maxRegexLength);
                boolean remapGlobalOrd = true;
                if (cardinality == CardinalityUpperBound.ONE && factories == AggregatorFactories.EMPTY && includeExclude == null) {
                    remapGlobalOrd = false;
                }
                return new GlobalOrdinalsStringTermsAggregator(name, factories, a -> {
                    GlobalOrdinalsStringTermsAggregator globalOrdinalsStringTermsAggregator = a;
                    Objects.requireNonNull(globalOrdinalsStringTermsAggregator);
                    return globalOrdinalsStringTermsAggregator.new GlobalOrdinalsStringTermsAggregator.SignificantTermsResults(lookup, significanceHeuristic, cardinality);
                }, (BytesValuesSource.WithOrdinals)((BytesValuesSource.WithOrdinals.FieldData)valuesSource), null, format, bucketCountThresholds, filter, aggregationContext, parent, remapGlobalOrd, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, cardinality, metadata);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            if ("global_ordinals".equals(value)) {
                return GLOBAL_ORDINALS;
            }
            if ("global_ordinals_hash".equals(value)) {
                deprecationLogger.deprecate("global_ordinals_hash", "global_ordinals_hash is deprecated. Please use [global_ordinals] instead.", new Object[0]);
                return GLOBAL_ORDINALS;
            }
            if ("map".equals(value)) {
                return MAP;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, DocValueFormat var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, SearchExecutionContext var7, Aggregator var8, SignificanceHeuristic var9, SignificanceLookup var10, CardinalityUpperBound var11, Map<String, Object> var12) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

