/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.plugins.spi.NamedXContentProvider;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;

public class StringTerms
extends InternalMappedTerms<StringTerms, Bucket> {
    public static final String NAME = "sterms";

    public StringTerms(String name, BucketOrder reduceOrder, BucketOrder order, Map<String, Object> metadata, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError, TermsAggregator.BucketCountThresholds bucketCountThresholds) {
        super(name, reduceOrder, order, metadata, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError, bucketCountThresholds);
    }

    public StringTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public StringTerms create(List<Bucket> buckets) {
        return new StringTerms(this.name, this.reduceOrder, this.order, (Map<String, Object>)this.metadata, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError, this.bucketCountThresholds);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.termBytes, docCount, aggs, prototype.showDocCountError, docCountError, this.format);
    }

    @Override
    protected StringTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new StringTerms(name, reduceOrder, this.order, (Map<String, Object>)this.getMetadata(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError, this.bucketCountThresholds);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    public static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        BytesRef termBytes;

        public Bucket(BytesRef term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.termBytes = term;
        }

        public Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.termBytes = in.readBytesRef();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.termBytes);
        }

        public Object getKey() {
            return this.getKeyAsString();
        }

        @Override
        public Number getKeyAsNumber() {
            try {
                return Long.parseLong(this.termBytes.utf8ToString());
            }
            catch (NumberFormatException ignored) {
                return Double.parseDouble(this.termBytes.utf8ToString());
            }
        }

        public String getKeyAsString() {
            return this.format.format(this.termBytes).toString();
        }

        public int compareKey(Bucket other) {
            return this.termBytes.compareTo(other.termBytes);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.termBytes, ((Bucket)obj).termBytes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termBytes);
        }
    }

    public static class NamedXContentProviderImpl
    implements NamedXContentProvider {
        public List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
            return Collections.singletonList(new NamedXContentRegistry.Entry(Aggregation.class, new ParseField(StringTerms.NAME, new String[0]), (p, c) -> ParsedStringTerms.fromXContent(p, (String)c)));
        }
    }
}

