/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.SkyliteException;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalOrder;
import io.skylite.core.aggregations.support.AggregationPath;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregator;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.internal.SearchContext;

public abstract class TermsAggregator
extends DeferableBucketAggregator {
    protected final DocValueFormat format;
    protected final BucketCountThresholds bucketCountThresholds;
    protected final BucketOrder order;
    protected final Comparator<InternalTerms.Bucket<?>> partiallyBuiltBucketComparator;
    protected final Set<Aggregator> aggsUsedForSorting = new HashSet<Aggregator>();
    protected final Aggregator.SubAggCollectionMode collectMode;

    public TermsAggregator(String name, AggregatorFactories factories, SearchExecutionContext context, Aggregator parent, BucketCountThresholds bucketCountThresholds, BucketOrder order, DocValueFormat format, Aggregator.SubAggCollectionMode collectMode, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.bucketCountThresholds = bucketCountThresholds;
        this.order = order;
        this.partiallyBuiltBucketComparator = order == null ? null : order.partiallyBuiltBucketComparator(b -> b.bucketOrd, (Aggregator)this);
        this.format = format;
        this.collectMode = this.subAggsNeedScore() && TermsAggregator.descendsFromNestedAggregator(parent) ? Aggregator.SubAggCollectionMode.DEPTH_FIRST : collectMode;
        if (order instanceof InternalOrder.Aggregation) {
            AggregationPath path = ((InternalOrder.Aggregation)order).path();
            this.aggsUsedForSorting.add(path.resolveTopmostAggregator((Aggregator)this));
        } else if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            for (BucketOrder orderElement : compoundOrder.orderElements()) {
                if (!(orderElement instanceof InternalOrder.Aggregation)) continue;
                AggregationPath path = ((InternalOrder.Aggregation)orderElement).path();
                this.aggsUsedForSorting.add(path.resolveTopmostAggregator((Aggregator)this));
            }
        }
    }

    static boolean descendsFromNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == NestedAggregator.class) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    private boolean subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return this.collectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST && !this.aggsUsedForSorting.contains(aggregator);
    }

    public static class BucketCountThresholds
    implements Writeable,
    ToXContentFragment {
        private long minDocCount;
        private long shardMinDocCount;
        private int requiredSize;
        private int shardSize;

        public BucketCountThresholds(long minDocCount, long shardMinDocCount, int requiredSize, int shardSize) {
            this.minDocCount = minDocCount;
            this.shardMinDocCount = shardMinDocCount;
            this.requiredSize = requiredSize;
            this.shardSize = shardSize;
        }

        public BucketCountThresholds(StreamInput in) throws IOException {
            this.requiredSize = in.readInt();
            this.shardSize = in.readInt();
            this.minDocCount = in.readLong();
            this.shardMinDocCount = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.requiredSize);
            out.writeInt(this.shardSize);
            out.writeLong(this.minDocCount);
            out.writeLong(this.shardMinDocCount);
        }

        public BucketCountThresholds(BucketCountThresholds bucketCountThresholds) {
            this(bucketCountThresholds.minDocCount, bucketCountThresholds.shardMinDocCount, bucketCountThresholds.requiredSize, bucketCountThresholds.shardSize);
        }

        public void ensureValidity() {
            if (this.shardSize < this.requiredSize) {
                this.setShardSize(this.requiredSize);
            }
            if (this.shardMinDocCount > this.minDocCount) {
                this.setShardMinDocCount(this.minDocCount);
            }
            if (this.requiredSize <= 0 || this.shardSize <= 0) {
                throw new SkyliteException("parameters [required_size] and [shard_size] must be >0 in terms aggregation.", new Object[0]);
            }
            if (this.minDocCount < 0L || this.shardMinDocCount < 0L) {
                throw new SkyliteException("parameter [min_doc_count] and [shardMinDocCount] must be >=0 in terms aggregation.", new Object[0]);
            }
        }

        public long getShardMinDocCount() {
            return this.shardMinDocCount;
        }

        public void setShardMinDocCount(long shardMinDocCount) {
            this.shardMinDocCount = shardMinDocCount;
        }

        public long getMinDocCount() {
            return this.minDocCount;
        }

        public void setMinDocCount(long minDocCount) {
            this.minDocCount = minDocCount;
        }

        public int getRequiredSize() {
            return this.requiredSize;
        }

        public void setRequiredSize(int requiredSize) {
            this.requiredSize = requiredSize;
        }

        public int getShardSize() {
            return this.shardSize;
        }

        public void setShardSize(int shardSize) {
            this.shardSize = shardSize;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(TermsAggregationBuilder.REQUIRED_SIZE_FIELD_NAME.getPreferredName(), this.requiredSize);
            if (this.shardSize != -1) {
                builder.field(TermsAggregationBuilder.SHARD_SIZE_FIELD_NAME.getPreferredName(), this.shardSize);
            }
            builder.field(TermsAggregationBuilder.MIN_DOC_COUNT_FIELD_NAME.getPreferredName(), this.minDocCount);
            builder.field(TermsAggregationBuilder.SHARD_MIN_DOC_COUNT_FIELD_NAME.getPreferredName(), this.shardMinDocCount);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.requiredSize, this.shardSize, this.minDocCount, this.shardMinDocCount);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BucketCountThresholds other = (BucketCountThresholds)obj;
            return Objects.equals(this.requiredSize, other.requiredSize) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.shardMinDocCount, other.shardMinDocCount);
        }

        public LocalBucketCountThresholds asLocalBucketCountThresholds(InternalAggregation.ReduceContext reduceContext) {
            if (reduceContext.isSliceLevel()) {
                return new LocalBucketCountThresholds(this.getShardMinDocCount(), this.getShardSize());
            }
            return new LocalBucketCountThresholds(this.getMinDocCount(), this.getRequiredSize());
        }

        public LocalBucketCountThresholds asLocalBucketCountThresholds(SearchExecutionContext searchContext) {
            if (((SearchContext)searchContext).shouldUseConcurrentSearch()) {
                return new LocalBucketCountThresholds(0L, ArrayUtil.MAX_ARRAY_LENGTH - 1);
            }
            return new LocalBucketCountThresholds(this.getShardMinDocCount(), this.getShardSize());
        }
    }

    public static class CoordinatorBucketCountThresholds
    extends BucketCountThresholds {
        public CoordinatorBucketCountThresholds(long minDocCount, long shardMinDocCount, int requiredSize, int shardSize) {
            super(minDocCount, shardMinDocCount, requiredSize, shardSize);
        }

        @Override
        public long getShardMinDocCount() {
            throw new AggregationExecutionException("shard_min_doc_count should not be accessed via CoordinatorBucketCountThresholds");
        }

        @Override
        public int getShardSize() {
            throw new AggregationExecutionException("shard_size should not be accessed via CoordinatorBucketCountThresholds");
        }
    }
}

