/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalOrder;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.bucket.BucketUtils;
import org.opensearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.MapStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.NumericTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.internal.SearchContext;

public class TermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    static Boolean REMAP_GLOBAL_ORDS;
    static Boolean COLLECT_SEGMENT_ORDS;
    private final BucketOrder order;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;

    static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(TermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), (Object)TermsAggregatorFactory.bytesSupplier(), true);
        builder.register(TermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), (Object)TermsAggregatorFactory.numericSupplier(), true);
    }

    private static TermsAggregatorSupplier bytesSupplier() {
        return (name, factories, valuesSource, order, format, bucketCountThresholds, includeExclude, executionHint, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata) -> {
            long maxOrd;
            ExecutionMode execution = null;
            if (executionHint != null) {
                execution = ExecutionMode.fromString(executionHint);
            }
            if (!(valuesSource instanceof BytesValuesSource.WithOrdinals)) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null) {
                execution = ExecutionMode.GLOBAL_ORDINALS;
            }
            long l = maxOrd = execution == ExecutionMode.GLOBAL_ORDINALS ? TermsAggregatorFactory.getMaxOrd(valuesSource, (IndexSearcher)((SearchContext)context).searcher()) : -1L;
            if (subAggCollectMode == null) {
                subAggCollectMode = TermsAggregatorFactory.pickSubAggColectMode(factories, bucketCountThresholds.getShardSize(), maxOrd);
            }
            if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                throw new AggregationExecutionException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
            }
            return execution.create(name, factories, valuesSource, order, format, bucketCountThresholds, includeExclude, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata);
        };
    }

    private static TermsAggregatorSupplier numericSupplier() {
        return (name, factories, valuesSource, order, format, bucketCountThresholds, includeExclude, executionHint, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata) -> {
            Function<NumericTermsAggregator, NumericTermsAggregator.ResultStrategy<?, ?>> resultStrategy;
            if (includeExclude != null && includeExclude.isRegexBased()) {
                throw new AggregationExecutionException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
            }
            if (subAggCollectMode == null) {
                subAggCollectMode = TermsAggregatorFactory.pickSubAggColectMode(factories, bucketCountThresholds.getShardSize(), -1L);
            }
            NumericValuesSource numericValuesSource = (NumericValuesSource)valuesSource;
            IncludeExclude.LongFilter longFilter = null;
            if (numericValuesSource.isFloatingPoint()) {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToDoubleFilter();
                }
                resultStrategy = agg -> {
                    NumericTermsAggregator numericTermsAggregator = agg;
                    Objects.requireNonNull(numericTermsAggregator);
                    return numericTermsAggregator.new NumericTermsAggregator.DoubleTermsResults(showTermDocCountError);
                };
            } else if (numericValuesSource.isBigInteger()) {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToDoubleFilter();
                }
                resultStrategy = agg -> {
                    NumericTermsAggregator numericTermsAggregator = agg;
                    Objects.requireNonNull(numericTermsAggregator);
                    return numericTermsAggregator.new NumericTermsAggregator.UnsignedLongTermsResults(showTermDocCountError);
                };
            } else {
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToLongFilter(format);
                }
                resultStrategy = agg -> {
                    NumericTermsAggregator numericTermsAggregator = agg;
                    Objects.requireNonNull(numericTermsAggregator);
                    return numericTermsAggregator.new NumericTermsAggregator.LongTermsResults(showTermDocCountError);
                };
            }
            return new NumericTermsAggregator(name, factories, resultStrategy, numericValuesSource, format, order, bucketCountThresholds, context, parent, subAggCollectMode, longFilter, cardinality, metadata);
        };
    }

    TermsAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, IncludeExclude includeExclude, String executionHint, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, boolean showTermDocCountError, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.order = order;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
        this.showTermDocCountError = showTermDocCountError;
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds, metadata);
        NonCollectingAggregator agg = new NonCollectingAggregator(this, this.name, searchContext, parent, this.factories, metadata){

            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
        this.order.validate((Aggregator)agg);
        return agg;
    }

    private static boolean isAggregationSort(BucketOrder order) {
        if (order instanceof InternalOrder.Aggregation) {
            return true;
        }
        if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            return compoundOrder.orderElements().stream().anyMatch(TermsAggregatorFactory::isAggregationSort);
        }
        return false;
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        TermsAggregatorSupplier aggregatorSupplier = (TermsAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(TermsAggregationBuilder.REGISTRY_KEY, this.config);
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (!InternalOrder.isKeyOrder((BucketOrder)this.order) && bucketCountThresholds.getShardSize() == TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        bucketCountThresholds.ensureValidity();
        return aggregatorSupplier.build(this.name, this.factories, this.config.getValuesSource(), this.order, this.config.format(), bucketCountThresholds, this.includeExclude, this.executionHint, searchContext, parent, this.collectMode, this.showTermDocCountError, cardinality, metadata);
    }

    static Aggregator.SubAggCollectionMode pickSubAggColectMode(AggregatorFactories factories, int expectedSize, long maxOrd) {
        if (factories.countAggregators() == 0) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (expectedSize == Integer.MAX_VALUE) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (maxOrd == -1L || maxOrd > (long)expectedSize) {
            return Aggregator.SubAggCollectionMode.BREADTH_FIRST;
        }
        return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
    }

    private static long getMaxOrd(ValuesSource source, IndexSearcher searcher) throws IOException {
        if (source instanceof BytesValuesSource.WithOrdinals) {
            BytesValuesSource.WithOrdinals valueSourceWithOrdinals = (BytesValuesSource.WithOrdinals)source;
            return valueSourceWithOrdinals.globalMaxOrd(searcher);
        }
        return -1L;
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchExecutionContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                int maxRegexLength = context.getQueryShardContext().getIndexSettings().getMaxRegexLength();
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format, maxRegexLength);
                return new MapStringTermsAggregator(name, factories, new MapStringTermsAggregator.ValuesSourceCollectorSource(valuesSource), a -> {
                    MapStringTermsAggregator mapStringTermsAggregator = a;
                    Objects.requireNonNull(mapStringTermsAggregator);
                    return mapStringTermsAggregator.new MapStringTermsAggregator.StandardTermsResults(valuesSource);
                }, order, format, bucketCountThresholds, filter, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchExecutionContext searchExecutionContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                boolean remapGlobalOrds;
                IncludeExclude.OrdinalsFilter filter;
                SearchContext context = (SearchContext)searchExecutionContext;
                long maxOrd = TermsAggregatorFactory.getMaxOrd(valuesSource, (IndexSearcher)context.searcher());
                assert (maxOrd != -1L);
                double ratio = (double)maxOrd / (double)context.searcher().getIndexReader().numDocs();
                assert (valuesSource instanceof BytesValuesSource.WithOrdinals);
                BytesValuesSource.WithOrdinals ordinalsValuesSource = (BytesValuesSource.WithOrdinals)valuesSource;
                if (factories == AggregatorFactories.EMPTY && includeExclude == null && cardinality == CardinalityUpperBound.ONE && ordinalsValuesSource.supportsGlobalOrdinalsMapping() && (COLLECT_SEGMENT_ORDS != null ? COLLECT_SEGMENT_ORDS != false : ratio <= 0.5 && maxOrd <= 2048L)) {
                    return new GlobalOrdinalsStringTermsAggregator.LowCardinality(name, factories, a -> (GlobalOrdinalsStringTermsAggregator)((Object)a).new GlobalOrdinalsStringTermsAggregator.StandardTermsResults(), ordinalsValuesSource, order, format, bucketCountThresholds, context, parent, false, subAggCollectMode, showTermDocCountError, metadata);
                }
                int maxRegexLength = context.getQueryShardContext().getIndexSettings().getMaxRegexLength();
                IncludeExclude.OrdinalsFilter ordinalsFilter = filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format, maxRegexLength);
                if (cardinality == CardinalityUpperBound.ONE && REMAP_GLOBAL_ORDS != null) {
                    remapGlobalOrds = REMAP_GLOBAL_ORDS;
                } else {
                    remapGlobalOrds = true;
                    if (includeExclude == null && cardinality == CardinalityUpperBound.ONE && (factories == AggregatorFactories.EMPTY || !TermsAggregatorFactory.isAggregationSort(order) && subAggCollectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST)) {
                        remapGlobalOrds = false;
                    }
                }
                return new GlobalOrdinalsStringTermsAggregator(name, factories, a -> (GlobalOrdinalsStringTermsAggregator)((Object)a).new GlobalOrdinalsStringTermsAggregator.StandardTermsResults(), ordinalsValuesSource, order, format, bucketCountThresholds, filter, context, parent, remapGlobalOrds, subAggCollectMode, showTermDocCountError, cardinality, metadata);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            switch (value) {
                case "global_ordinals": {
                    return GLOBAL_ORDINALS;
                }
                case "map": {
                    return MAP;
                }
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, BucketOrder var4, DocValueFormat var5, TermsAggregator.BucketCountThresholds var6, IncludeExclude var7, SearchExecutionContext var8, Aggregator var9, Aggregator.SubAggCollectionMode var10, boolean var11, CardinalityUpperBound var12, Map<String, Object> var13) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

