/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.opensearch.search.aggregations.metrics.CardinalityAggregator;
import org.opensearch.search.aggregations.metrics.CardinalityAggregatorSupplier;
import org.opensearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

class CardinalityAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Long precisionThreshold;

    CardinalityAggregatorFactory(String name, ValuesSourceConfig config, Long precisionThreshold, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.precisionThreshold = precisionThreshold;
    }

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(CardinalityAggregationBuilder.REGISTRY_KEY, Stream.of(CoreValuesSourceType.ALL_CORE, GeoValuesSourceType.ALL).flatMap(x -> x.stream()).collect(Collectors.toUnmodifiableList()), CardinalityAggregator::new, true);
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new CardinalityAggregator(this.name, this.config, this.precision(), searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((CardinalityAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(CardinalityAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.config, this.precision(), searchContext, parent, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    private int precision() {
        return this.precisionThreshold == null ? 14 : HyperLogLogPlusPlus.precisionFromThreshold(this.precisionThreshold);
    }
}

