/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.collect.Tuple;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.metrics.ExtendedStatsAggregator;
import org.opensearch.search.aggregations.metrics.ExtendedStatsAggregatorFactory;
import org.opensearch.search.aggregations.metrics.ExtendedStatsAggregatorProvider;
import org.opensearch.search.aggregations.metrics.InternalExtendedStats;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class ExtendedStatsAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<NumericValuesSource, ExtendedStatsAggregationBuilder> {
    public static final String NAME = "extended_stats";
    public static final AggregationRegistry.RegistryKey<ExtendedStatsAggregatorProvider> REGISTRY_KEY = new AggregationRegistry.RegistryKey("extended_stats", ExtendedStatsAggregatorProvider.class);
    public static final ObjectParser<ExtendedStatsAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"extended_stats", ExtendedStatsAggregationBuilder::new);
    private double sigma = 2.0;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        ExtendedStatsAggregatorFactory.registerAggregators(builder);
    }

    public ExtendedStatsAggregationBuilder(String name) {
        super(name);
    }

    protected ExtendedStatsAggregationBuilder(ExtendedStatsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.sigma = clone.sigma;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ExtendedStatsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ExtendedStatsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.sigma = in.readDouble();
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sigma);
    }

    public ExtendedStatsAggregationBuilder sigma(double sigma) {
        if (sigma < 0.0) {
            throw new IllegalArgumentException("[sigma] must be greater than or equal to 0. Found [" + sigma + "] in [" + this.name + "]");
        }
        this.sigma = sigma;
        return this;
    }

    public double sigma() {
        return this.sigma;
    }

    @Override
    protected ExtendedStatsAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ExtendedStatsAggregatorFactory(this.name, config, this.sigma, context, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ExtendedStatsAggregator.SIGMA_FIELD.getPreferredName(), this.sigma);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sigma);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ExtendedStatsAggregationBuilder other = (ExtendedStatsAggregationBuilder)((Object)obj);
        return Objects.equals(this.sigma, other.sigma);
    }

    public String getType() {
        return NAME;
    }

    @Override
    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, false);
        PARSER.declareDouble(ExtendedStatsAggregationBuilder::sigma, ExtendedStatsAggregator.SIGMA_FIELD);
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.METRIC;
        }

        public String getName() {
            return ExtendedStatsAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return ExtendedStatsAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalExtendedStats::new));
        }

        public ObjectParser getParser() {
            return PARSER;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return ExtendedStatsAggregationBuilder::registerAggregators;
        }
    }
}

