/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.DoubleArray;
import io.skylite.core.common.util.LongArray;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.index.fielddata.geo.MultiGeoPointValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalGeoCentroid;
import org.opensearch.search.aggregations.metrics.MetricsAggregator;

final class GeoCentroidAggregator
extends MetricsAggregator {
    private final GeoPointValuesSource valuesSource;
    private DoubleArray lonSum;
    private DoubleArray lonCompensations;
    private DoubleArray latSum;
    private DoubleArray latCompensations;
    private LongArray counts;

    GeoCentroidAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        GeoPointValuesSource geoPointValuesSource = this.valuesSource = valuesSourceConfig.hasValues() ? (GeoPointValuesSource)valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.lonSum = bigArrays.newDoubleArray(1L, true);
            this.lonCompensations = bigArrays.newDoubleArray(1L, true);
            this.latSum = bigArrays.newDoubleArray(1L, true);
            this.latCompensations = bigArrays.newDoubleArray(1L, true);
            this.counts = bigArrays.newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoPointValues values = this.valuesSource.geoPointValues(ctx);
        final CompensatedSum compensatedSumLat = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumLon = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                GeoCentroidAggregator.this.latSum = bigArrays.grow(GeoCentroidAggregator.this.latSum, bucket + 1L);
                GeoCentroidAggregator.this.lonSum = bigArrays.grow(GeoCentroidAggregator.this.lonSum, bucket + 1L);
                GeoCentroidAggregator.this.lonCompensations = bigArrays.grow(GeoCentroidAggregator.this.lonCompensations, bucket + 1L);
                GeoCentroidAggregator.this.latCompensations = bigArrays.grow(GeoCentroidAggregator.this.latCompensations, bucket + 1L);
                GeoCentroidAggregator.this.counts = bigArrays.grow(GeoCentroidAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    GeoCentroidAggregator.this.counts.increment(bucket, (long)valueCount);
                    double sumLat = GeoCentroidAggregator.this.latSum.get(bucket);
                    double compensationLat = GeoCentroidAggregator.this.latCompensations.get(bucket);
                    double sumLon = GeoCentroidAggregator.this.lonSum.get(bucket);
                    double compensationLon = GeoCentroidAggregator.this.lonCompensations.get(bucket);
                    compensatedSumLat.reset(sumLat, compensationLat);
                    compensatedSumLon.reset(sumLon, compensationLon);
                    for (int i = 0; i < valueCount; ++i) {
                        GeoPoint value = values.nextValue();
                        compensatedSumLat.add(value.getLat());
                        compensatedSumLon.add(value.getLon());
                    }
                    GeoCentroidAggregator.this.lonSum.set(bucket, compensatedSumLon.value());
                    GeoCentroidAggregator.this.lonCompensations.set(bucket, compensatedSumLon.delta());
                    GeoCentroidAggregator.this.latSum.set(bucket, compensatedSumLat.value());
                    GeoCentroidAggregator.this.latCompensations.set(bucket, compensatedSumLat.delta());
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        GeoPoint bucketCentroid = bucketCount > 0L ? new GeoPoint(this.latSum.get(bucket) / (double)bucketCount, this.lonSum.get(bucket) / (double)bucketCount) : null;
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoCentroid(this.name, null, 0L, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.latSum, this.latCompensations, this.lonSum, this.lonCompensations, this.counts});
    }
}

