/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.opensearch.search.aggregations.metrics.AbstractHDRPercentilesAggregator;
import org.opensearch.search.aggregations.metrics.InternalHDRPercentiles;

class HDRPercentilesAggregator
extends AbstractHDRPercentilesAggregator {
    HDRPercentilesAggregator(String name, ValuesSource valuesSource, SearchExecutionContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, numberOfSignificantValueDigits, keyed, formatter, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentiles(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return state.getValueAtPercentile(Double.parseDouble(name));
    }

    public InternalAggregation buildEmptyAggregation() {
        DoubleHistogram state = new DoubleHistogram(this.numberOfSignificantValueDigits);
        state.setAutoResize(true);
        return new InternalHDRPercentiles(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }
}

