/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.opensearch.search.aggregations.metrics.GeoCentroid;

public class InternalGeoCentroid
extends InternalAggregation
implements GeoCentroid {
    private final GeoPoint centroid;
    private final long count;

    public static long encodeLatLon(double lat, double lon) {
        return Integer.toUnsignedLong(GeoEncodingUtils.encodeLatitude((double)lat)) << 32 | Integer.toUnsignedLong(GeoEncodingUtils.encodeLongitude((double)lon));
    }

    public static double decodeLatitude(long encodedLatLon) {
        return GeoEncodingUtils.decodeLatitude((int)((int)(encodedLatLon >>> 32)));
    }

    public static double decodeLongitude(long encodedLatLon) {
        return GeoEncodingUtils.decodeLongitude((int)((int)(encodedLatLon & 0xFFFFFFFFL)));
    }

    public InternalGeoCentroid(String name, GeoPoint centroid, long count, Map<String, Object> metadata) {
        super(name, metadata);
        assert (centroid == null == (count == 0L));
        this.centroid = centroid;
        assert (count >= 0L);
        this.count = count;
    }

    public InternalGeoCentroid(StreamInput in) throws IOException {
        super(in);
        this.count = in.readVLong();
        this.centroid = in.readBoolean() ? new GeoPoint(in.readDouble(), in.readDouble()) : null;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (this.centroid != null) {
            out.writeBoolean(true);
            out.writeDouble(this.centroid.lat());
            out.writeDouble(this.centroid.lon());
        } else {
            out.writeBoolean(false);
        }
    }

    public String getWriteableName() {
        return "geo_centroid";
    }

    @Override
    public GeoPoint centroid() {
        return this.centroid;
    }

    @Override
    public long count() {
        return this.count;
    }

    public InternalGeoCentroid reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double lonSum = Double.NaN;
        double latSum = Double.NaN;
        long totalCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoCentroid centroidAgg = (InternalGeoCentroid)aggregation;
            if (centroidAgg.count <= 0L) continue;
            totalCount += centroidAgg.count;
            if (Double.isNaN(lonSum)) {
                lonSum = (double)centroidAgg.count * centroidAgg.centroid.getLon();
                latSum = (double)centroidAgg.count * centroidAgg.centroid.getLat();
                continue;
            }
            lonSum += (double)centroidAgg.count * centroidAgg.centroid.getLon();
            latSum += (double)centroidAgg.count * centroidAgg.centroid.getLat();
        }
        GeoPoint result = Double.isNaN(lonSum) ? null : new GeoPoint(latSum / (double)totalCount, lonSum / (double)totalCount);
        return new InternalGeoCentroid(this.name, result, totalCount, this.getMetadata());
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String coordinate;
            switch (coordinate = path.get(0)) {
                case "value": {
                    return this.centroid;
                }
                case "lat": {
                    return this.centroid.lat();
                }
                case "lon": {
                    return this.centroid.lon();
                }
                case "count": {
                    return this.count;
                }
            }
            throw new IllegalArgumentException("Found unknown path element [" + coordinate + "] in [" + this.getName() + "]");
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + String.valueOf(path));
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(Fields.CENTROID.getPreferredName());
            builder.field(Fields.CENTROID_LAT.getPreferredName(), this.centroid.lat());
            builder.field(Fields.CENTROID_LON.getPreferredName(), this.centroid.lon());
            builder.endObject();
        }
        builder.field(Fields.COUNT.getPreferredName(), this.count);
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoCentroid that = (InternalGeoCentroid)obj;
        return this.count == that.count && Objects.equals(this.centroid, that.centroid);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.centroid, this.count);
    }

    public String toString() {
        return "InternalGeoCentroid{centroid=" + String.valueOf(this.centroid) + ", count=" + this.count + "}";
    }

    static class Fields {
        static final ParseField CENTROID = new ParseField("location", new String[0]);
        static final ParseField COUNT = new ParseField("count", new String[0]);
        static final ParseField CENTROID_LAT = new ParseField("lat", new String[0]);
        static final ParseField CENTROID_LON = new ParseField("lon", new String[0]);

        Fields() {
        }
    }
}

