/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.script.ScriptedMetricAggContexts;
import org.opensearch.search.aggregations.metrics.ScriptedMetric;

public class InternalScriptedMetric
extends InternalAggregation
implements ScriptedMetric {
    final Script reduceScript;
    private final List<Object> aggregations;

    InternalScriptedMetric(String name, List<Object> aggregations, Script reduceScript, Map<String, Object> metadata) {
        super(name, metadata);
        this.aggregations = aggregations;
        this.reduceScript = reduceScript;
    }

    public InternalScriptedMetric(StreamInput in) throws IOException {
        super(in);
        this.reduceScript = (Script)in.readOptionalWriteable(Script::new);
        this.aggregations = in.readList(StreamInput::readGenericValue);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.reduceScript);
        out.writeCollection(this.aggregations, StreamOutput::writeGenericValue);
    }

    public String getWriteableName() {
        return "scripted_metric";
    }

    @Override
    public Object aggregation() {
        if (this.aggregations.size() != 1) {
            throw new IllegalStateException("aggregation was not reduced");
        }
        return this.aggregations.get(0);
    }

    List<Object> aggregationsList() {
        return this.aggregations;
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        Object aggregation2;
        ArrayList<Object> aggregationObjects = new ArrayList<Object>();
        for (Object aggregation2 : aggregations) {
            InternalScriptedMetric mapReduceAggregation = (InternalScriptedMetric)aggregation2;
            aggregationObjects.addAll(mapReduceAggregation.aggregations);
        }
        InternalScriptedMetric firstAggregation = (InternalScriptedMetric)aggregations.get(0);
        if (firstAggregation.reduceScript != null && reduceContext.isFinalReduce()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (firstAggregation.reduceScript.getParams() != null) {
                params.putAll(firstAggregation.reduceScript.getParams());
            }
            ScriptedMetricAggContexts.ReduceScript.Factory factory = (ScriptedMetricAggContexts.ReduceScript.Factory)reduceContext.scriptService().compile(firstAggregation.reduceScript, ScriptedMetricAggContexts.ReduceScript.CONTEXT);
            ScriptedMetricAggContexts.ReduceScript script = factory.newInstance(params, aggregationObjects);
            Object scriptResult = script.execute();
            CollectionUtils.ensureNoSelfReferences((Object)scriptResult, (String)"reduce script");
            aggregation2 = Collections.singletonList(scriptResult);
        } else {
            aggregation2 = reduceContext.isFinalReduce() ? Collections.singletonList(aggregationObjects) : aggregationObjects;
        }
        return new InternalScriptedMetric(firstAggregation.getName(), (List<Object>)aggregation2, firstAggregation.reduceScript, this.getMetadata());
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.aggregation();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + String.valueOf(path));
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.aggregation());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalScriptedMetric other = (InternalScriptedMetric)obj;
        return Objects.equals(this.reduceScript, other.reduceScript) && Objects.equals(this.aggregations, other.aggregations);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reduceScript, this.aggregations);
    }
}

