/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.InternalScriptedMetric;
import org.opensearch.search.aggregations.metrics.ValueCount;

public class InternalValueCount
extends InternalNumericMetricsAggregation.SingleValue
implements ValueCount {
    private final long value;

    public InternalValueCount(String name, long value, Map<String, Object> metadata) {
        super(name, metadata);
        this.value = value;
    }

    public InternalValueCount(StreamInput in) throws IOException {
        super(in);
        this.value = in.readVLong();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.value);
    }

    public String getWriteableName() {
        return "value_count";
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public double value() {
        return this.value;
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long valueCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            if (aggregation instanceof InternalScriptedMetric) {
                Object value = ((InternalScriptedMetric)aggregation).aggregation();
                if (value instanceof Number) {
                    valueCount += ((Number)value).longValue();
                    continue;
                }
                throw new IllegalArgumentException("Invalid ScriptedMetric result for [" + this.getName() + "] valueCount aggregation. Expected numeric value from ScriptedMetric aggregation but got [" + (value == null ? "null" : value.getClass().getName()) + "]");
            }
            valueCount += ((InternalValueCount)aggregation).value;
        }
        return new InternalValueCount(this.name, valueCount, this.getMetadata());
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.value);
        return builder;
    }

    public String toString() {
        return "count[" + this.value + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalValueCount that = (InternalValueCount)obj;
        return Objects.equals(this.value, that.value);
    }
}

